/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.tasks;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.GroupBy;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.tasks.ListResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class ListRequest
extends RequestBase {
    @Nullable
    private final List<String> actions;
    @Nullable
    private final Boolean detailed;
    @Nullable
    private final GroupBy groupBy;
    @Nullable
    private final List<String> nodes;
    @Nullable
    private final String parentTaskId;
    @Nullable
    private final String timeout;
    @Nullable
    private final Boolean waitForCompletion;
    public static final Endpoint<ListRequest, ListResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ListRequest, ListResponse>(request -> "GET", request -> "/_tasks", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.actions != null) {
            params.put("actions", request.actions.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.detailed != null) {
            params.put("detailed", String.valueOf(request.detailed));
        }
        if (request.groupBy != null) {
            params.put("group_by", request.groupBy.toString());
        }
        if (request.nodes != null) {
            params.put("nodes", request.nodes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.parentTaskId != null) {
            params.put("parent_task_id", request.parentTaskId);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, ListResponse._DESERIALIZER);

    public ListRequest(Builder builder) {
        this.actions = ModelTypeHelper.unmodifiable(builder.actions);
        this.detailed = builder.detailed;
        this.groupBy = builder.groupBy;
        this.nodes = ModelTypeHelper.unmodifiable(builder.nodes);
        this.parentTaskId = builder.parentTaskId;
        this.timeout = builder.timeout;
        this.waitForCompletion = builder.waitForCompletion;
    }

    public ListRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> actions() {
        return this.actions;
    }

    @Nullable
    public Boolean detailed() {
        return this.detailed;
    }

    @Nullable
    public GroupBy groupBy() {
        return this.groupBy;
    }

    @Nullable
    public List<String> nodes() {
        return this.nodes;
    }

    @Nullable
    public String parentTaskId() {
        return this.parentTaskId;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public static class Builder
    implements ObjectBuilder<ListRequest> {
        @Nullable
        private List<String> actions;
        @Nullable
        private Boolean detailed;
        @Nullable
        private GroupBy groupBy;
        @Nullable
        private List<String> nodes;
        @Nullable
        private String parentTaskId;
        @Nullable
        private String timeout;
        @Nullable
        private Boolean waitForCompletion;

        public Builder actions(@Nullable List<String> value) {
            this.actions = value;
            return this;
        }

        public Builder actions(String ... value) {
            this.actions = Arrays.asList(value);
            return this;
        }

        public Builder addActions(String value) {
            if (this.actions == null) {
                this.actions = new ArrayList<String>();
            }
            this.actions.add(value);
            return this;
        }

        public Builder detailed(@Nullable Boolean value) {
            this.detailed = value;
            return this;
        }

        public Builder groupBy(@Nullable GroupBy value) {
            this.groupBy = value;
            return this;
        }

        public Builder nodes(@Nullable List<String> value) {
            this.nodes = value;
            return this;
        }

        public Builder nodes(String ... value) {
            this.nodes = Arrays.asList(value);
            return this;
        }

        public Builder addNodes(String value) {
            if (this.nodes == null) {
                this.nodes = new ArrayList<String>();
            }
            this.nodes.add(value);
            return this;
        }

        public Builder parentTaskId(@Nullable String value) {
            this.parentTaskId = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        public ListRequest build() {
            return new ListRequest(this);
        }
    }
}

