/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.tasks;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch.tasks.Info;
import co.elastic.clients.elasticsearch.tasks.Status;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GetTasksResponse
implements JsonpSerializable {
    private final boolean completed;
    private final Info task;
    @Nullable
    private final Status response;
    @Nullable
    private final ErrorCause error;
    public static final JsonpDeserializer<GetTasksResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetTasksResponse::setupGetTasksResponseDeserializer, Builder::build);

    public GetTasksResponse(Builder builder) {
        this.completed = Objects.requireNonNull(builder.completed, "completed");
        this.task = Objects.requireNonNull(builder.task, "task");
        this.response = builder.response;
        this.error = builder.error;
    }

    public GetTasksResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean completed() {
        return this.completed;
    }

    public Info task() {
        return this.task;
    }

    @Nullable
    public Status response() {
        return this.response;
    }

    @Nullable
    public ErrorCause error() {
        return this.error;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("completed");
        generator.write(this.completed);
        generator.writeKey("task");
        this.task.serialize(generator, mapper);
        if (this.response != null) {
            generator.writeKey("response");
            this.response.serialize(generator, mapper);
        }
        if (this.error != null) {
            generator.writeKey("error");
            this.error.serialize(generator, mapper);
        }
    }

    protected static void setupGetTasksResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::completed, JsonpDeserializer.booleanDeserializer(), "completed", new String[0]);
        op.add(Builder::task, Info._DESERIALIZER, "task", new String[0]);
        op.add(Builder::response, Status._DESERIALIZER, "response", new String[0]);
        op.add(Builder::error, ErrorCause._DESERIALIZER, "error", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetTasksResponse> {
        private Boolean completed;
        private Info task;
        @Nullable
        private Status response;
        @Nullable
        private ErrorCause error;

        public Builder completed(boolean value) {
            this.completed = value;
            return this;
        }

        public Builder task(Info value) {
            this.task = value;
            return this;
        }

        public Builder task(Function<Info.Builder, ObjectBuilder<Info>> fn) {
            return this.task(fn.apply(new Info.Builder()).build());
        }

        public Builder response(@Nullable Status value) {
            this.response = value;
            return this;
        }

        public Builder response(Function<Status.Builder, ObjectBuilder<Status>> fn) {
            return this.response(fn.apply(new Status.Builder()).build());
        }

        public Builder error(@Nullable ErrorCause value) {
            this.error = value;
            return this;
        }

        public Builder error(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.error(fn.apply(new ErrorCause.Builder()).build());
        }

        @Override
        public GetTasksResponse build() {
            return new GetTasksResponse(this);
        }
    }
}

