/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.sql;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.sql.QueryResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class QueryRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String format;
    @Nullable
    private final Boolean columnar;
    @Nullable
    private final String cursor;
    @Nullable
    private final Integer fetchSize;
    @Nullable
    private final Query filter;
    @Nullable
    private final String query;
    @Nullable
    private final String requestTimeout;
    @Nullable
    private final String pageTimeout;
    @Nullable
    private final String timeZone;
    @Nullable
    private final Boolean fieldMultiValueLeniency;
    public static final JsonpDeserializer<QueryRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryRequest::setupQueryRequestDeserializer, Builder::build);
    public static final Endpoint<QueryRequest, QueryResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<QueryRequest, QueryResponse>(request -> "POST", request -> "/_sql", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.format != null) {
            params.put("format", request.format);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, QueryResponse._DESERIALIZER);

    public QueryRequest(Builder builder) {
        this.format = builder.format;
        this.columnar = builder.columnar;
        this.cursor = builder.cursor;
        this.fetchSize = builder.fetchSize;
        this.filter = builder.filter;
        this.query = builder.query;
        this.requestTimeout = builder.requestTimeout;
        this.pageTimeout = builder.pageTimeout;
        this.timeZone = builder.timeZone;
        this.fieldMultiValueLeniency = builder.fieldMultiValueLeniency;
    }

    public QueryRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String format() {
        return this.format;
    }

    @Nullable
    public Boolean columnar() {
        return this.columnar;
    }

    @Nullable
    public String cursor() {
        return this.cursor;
    }

    @Nullable
    public Integer fetchSize() {
        return this.fetchSize;
    }

    @Nullable
    public Query filter() {
        return this.filter;
    }

    @Nullable
    public String query() {
        return this.query;
    }

    @Nullable
    public String requestTimeout() {
        return this.requestTimeout;
    }

    @Nullable
    public String pageTimeout() {
        return this.pageTimeout;
    }

    @Nullable
    public String timeZone() {
        return this.timeZone;
    }

    @Nullable
    public Boolean fieldMultiValueLeniency() {
        return this.fieldMultiValueLeniency;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.columnar != null) {
            generator.writeKey("columnar");
            generator.write(this.columnar.booleanValue());
        }
        if (this.cursor != null) {
            generator.writeKey("cursor");
            generator.write(this.cursor);
        }
        if (this.fetchSize != null) {
            generator.writeKey("fetch_size");
            generator.write(this.fetchSize.intValue());
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.query != null) {
            generator.writeKey("query");
            generator.write(this.query);
        }
        if (this.requestTimeout != null) {
            generator.writeKey("request_timeout");
            generator.write(this.requestTimeout);
        }
        if (this.pageTimeout != null) {
            generator.writeKey("page_timeout");
            generator.write(this.pageTimeout);
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
        if (this.fieldMultiValueLeniency != null) {
            generator.writeKey("field_multi_value_leniency");
            generator.write(this.fieldMultiValueLeniency.booleanValue());
        }
    }

    protected static void setupQueryRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::columnar, JsonpDeserializer.booleanDeserializer(), "columnar", new String[0]);
        op.add(Builder::cursor, JsonpDeserializer.stringDeserializer(), "cursor", new String[0]);
        op.add(Builder::fetchSize, JsonpDeserializer.integerDeserializer(), "fetch_size", new String[0]);
        op.add(Builder::filter, Query._DESERIALIZER, "filter", new String[0]);
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query", new String[0]);
        op.add(Builder::requestTimeout, JsonpDeserializer.stringDeserializer(), "request_timeout", new String[0]);
        op.add(Builder::pageTimeout, JsonpDeserializer.stringDeserializer(), "page_timeout", new String[0]);
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone", new String[0]);
        op.add(Builder::fieldMultiValueLeniency, JsonpDeserializer.booleanDeserializer(), "field_multi_value_leniency", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<QueryRequest> {
        @Nullable
        private String format;
        @Nullable
        private Boolean columnar;
        @Nullable
        private String cursor;
        @Nullable
        private Integer fetchSize;
        @Nullable
        private Query filter;
        @Nullable
        private String query;
        @Nullable
        private String requestTimeout;
        @Nullable
        private String pageTimeout;
        @Nullable
        private String timeZone;
        @Nullable
        private Boolean fieldMultiValueLeniency;

        public Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public Builder columnar(@Nullable Boolean value) {
            this.columnar = value;
            return this;
        }

        public Builder cursor(@Nullable String value) {
            this.cursor = value;
            return this;
        }

        public Builder fetchSize(@Nullable Integer value) {
            this.fetchSize = value;
            return this;
        }

        public Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public Builder query(@Nullable String value) {
            this.query = value;
            return this;
        }

        public Builder requestTimeout(@Nullable String value) {
            this.requestTimeout = value;
            return this;
        }

        public Builder pageTimeout(@Nullable String value) {
            this.pageTimeout = value;
            return this;
        }

        public Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        public Builder fieldMultiValueLeniency(@Nullable Boolean value) {
            this.fieldMultiValueLeniency = value;
            return this;
        }

        @Override
        public QueryRequest build() {
            return new QueryRequest(this);
        }
    }
}

