/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot.restore;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class SnapshotRestore
implements JsonpSerializable {
    private final List<String> indices;
    private final String snapshot;
    private final ShardStatistics shards;
    public static final JsonpDeserializer<SnapshotRestore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotRestore::setupSnapshotRestoreDeserializer, Builder::build);

    public SnapshotRestore(Builder builder) {
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
        this.snapshot = Objects.requireNonNull(builder.snapshot, "snapshot");
        this.shards = Objects.requireNonNull(builder.shards, "shards");
    }

    public SnapshotRestore(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> indices() {
        return this.indices;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public ShardStatistics shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("indices");
        generator.writeStartArray();
        for (String item0 : this.indices) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("snapshot");
        generator.write(this.snapshot);
        generator.writeKey("shards");
        this.shards.serialize(generator, mapper);
    }

    protected static void setupSnapshotRestoreDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices", new String[0]);
        op.add(Builder::snapshot, JsonpDeserializer.stringDeserializer(), "snapshot", new String[0]);
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "shards", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SnapshotRestore> {
        private List<String> indices;
        private String snapshot;
        private ShardStatistics shards;

        public Builder indices(List<String> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(String ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(String value) {
            if (this.indices == null) {
                this.indices = new ArrayList<String>();
            }
            this.indices.add(value);
            return this;
        }

        public Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        public Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Override
        public SnapshotRestore build() {
            return new SnapshotRestore(this);
        }
    }
}

