/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.snapshot.DeleteSnapshotResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class DeleteSnapshotRequest
extends RequestBase {
    private final String repository;
    private final String snapshot;
    @Nullable
    private final String masterTimeout;
    public static final Endpoint<DeleteSnapshotRequest, DeleteSnapshotResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteSnapshotRequest, DeleteSnapshotResponse>(request -> "DELETE", request -> {
        boolean _repository = true;
        int _snapshot = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshot, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteSnapshotResponse._DESERIALIZER);

    public DeleteSnapshotRequest(Builder builder) {
        this.repository = Objects.requireNonNull(builder.repository, "repository");
        this.snapshot = Objects.requireNonNull(builder.snapshot, "snapshot");
        this.masterTimeout = builder.masterTimeout;
    }

    public DeleteSnapshotRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String repository() {
        return this.repository;
    }

    public String snapshot() {
        return this.snapshot;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    public static class Builder
    implements ObjectBuilder<DeleteSnapshotRequest> {
        private String repository;
        private String snapshot;
        @Nullable
        private String masterTimeout;

        public Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        @Override
        public DeleteSnapshotRequest build() {
            return new DeleteSnapshotRequest(this);
        }
    }
}

