/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GetStatsResponse
implements JsonpSerializable {
    private final String retentionDeletionTime;
    private final String retentionDeletionTimeMillis;
    private final long retentionFailed;
    private final long retentionRuns;
    private final long retentionTimedOut;
    private final long totalSnapshotsDeleted;
    private final long totalSnapshotDeletionFailures;
    private final long totalSnapshotsFailed;
    private final long totalSnapshotsTaken;
    private final List<String> policyStats;
    public static final JsonpDeserializer<GetStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetStatsResponse::setupGetStatsResponseDeserializer, Builder::build);

    public GetStatsResponse(Builder builder) {
        this.retentionDeletionTime = Objects.requireNonNull(builder.retentionDeletionTime, "retention_deletion_time");
        this.retentionDeletionTimeMillis = Objects.requireNonNull(builder.retentionDeletionTimeMillis, "retention_deletion_time_millis");
        this.retentionFailed = Objects.requireNonNull(builder.retentionFailed, "retention_failed");
        this.retentionRuns = Objects.requireNonNull(builder.retentionRuns, "retention_runs");
        this.retentionTimedOut = Objects.requireNonNull(builder.retentionTimedOut, "retention_timed_out");
        this.totalSnapshotsDeleted = Objects.requireNonNull(builder.totalSnapshotsDeleted, "total_snapshots_deleted");
        this.totalSnapshotDeletionFailures = Objects.requireNonNull(builder.totalSnapshotDeletionFailures, "total_snapshot_deletion_failures");
        this.totalSnapshotsFailed = Objects.requireNonNull(builder.totalSnapshotsFailed, "total_snapshots_failed");
        this.totalSnapshotsTaken = Objects.requireNonNull(builder.totalSnapshotsTaken, "total_snapshots_taken");
        this.policyStats = ModelTypeHelper.unmodifiableNonNull(builder.policyStats, "policy_stats");
    }

    public GetStatsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String retentionDeletionTime() {
        return this.retentionDeletionTime;
    }

    public String retentionDeletionTimeMillis() {
        return this.retentionDeletionTimeMillis;
    }

    public long retentionFailed() {
        return this.retentionFailed;
    }

    public long retentionRuns() {
        return this.retentionRuns;
    }

    public long retentionTimedOut() {
        return this.retentionTimedOut;
    }

    public long totalSnapshotsDeleted() {
        return this.totalSnapshotsDeleted;
    }

    public long totalSnapshotDeletionFailures() {
        return this.totalSnapshotDeletionFailures;
    }

    public long totalSnapshotsFailed() {
        return this.totalSnapshotsFailed;
    }

    public long totalSnapshotsTaken() {
        return this.totalSnapshotsTaken;
    }

    public List<String> policyStats() {
        return this.policyStats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("retention_deletion_time");
        generator.write(this.retentionDeletionTime);
        generator.writeKey("retention_deletion_time_millis");
        generator.write(this.retentionDeletionTimeMillis);
        generator.writeKey("retention_failed");
        generator.write(this.retentionFailed);
        generator.writeKey("retention_runs");
        generator.write(this.retentionRuns);
        generator.writeKey("retention_timed_out");
        generator.write(this.retentionTimedOut);
        generator.writeKey("total_snapshots_deleted");
        generator.write(this.totalSnapshotsDeleted);
        generator.writeKey("total_snapshot_deletion_failures");
        generator.write(this.totalSnapshotDeletionFailures);
        generator.writeKey("total_snapshots_failed");
        generator.write(this.totalSnapshotsFailed);
        generator.writeKey("total_snapshots_taken");
        generator.write(this.totalSnapshotsTaken);
        generator.writeKey("policy_stats");
        generator.writeStartArray();
        for (String item0 : this.policyStats) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupGetStatsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::retentionDeletionTime, JsonpDeserializer.stringDeserializer(), "retention_deletion_time", new String[0]);
        op.add(Builder::retentionDeletionTimeMillis, JsonpDeserializer.stringDeserializer(), "retention_deletion_time_millis", new String[0]);
        op.add(Builder::retentionFailed, JsonpDeserializer.longDeserializer(), "retention_failed", new String[0]);
        op.add(Builder::retentionRuns, JsonpDeserializer.longDeserializer(), "retention_runs", new String[0]);
        op.add(Builder::retentionTimedOut, JsonpDeserializer.longDeserializer(), "retention_timed_out", new String[0]);
        op.add(Builder::totalSnapshotsDeleted, JsonpDeserializer.longDeserializer(), "total_snapshots_deleted", new String[0]);
        op.add(Builder::totalSnapshotDeletionFailures, JsonpDeserializer.longDeserializer(), "total_snapshot_deletion_failures", new String[0]);
        op.add(Builder::totalSnapshotsFailed, JsonpDeserializer.longDeserializer(), "total_snapshots_failed", new String[0]);
        op.add(Builder::totalSnapshotsTaken, JsonpDeserializer.longDeserializer(), "total_snapshots_taken", new String[0]);
        op.add(Builder::policyStats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "policy_stats", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetStatsResponse> {
        private String retentionDeletionTime;
        private String retentionDeletionTimeMillis;
        private Long retentionFailed;
        private Long retentionRuns;
        private Long retentionTimedOut;
        private Long totalSnapshotsDeleted;
        private Long totalSnapshotDeletionFailures;
        private Long totalSnapshotsFailed;
        private Long totalSnapshotsTaken;
        private List<String> policyStats;

        public Builder retentionDeletionTime(String value) {
            this.retentionDeletionTime = value;
            return this;
        }

        public Builder retentionDeletionTimeMillis(String value) {
            this.retentionDeletionTimeMillis = value;
            return this;
        }

        public Builder retentionFailed(long value) {
            this.retentionFailed = value;
            return this;
        }

        public Builder retentionRuns(long value) {
            this.retentionRuns = value;
            return this;
        }

        public Builder retentionTimedOut(long value) {
            this.retentionTimedOut = value;
            return this;
        }

        public Builder totalSnapshotsDeleted(long value) {
            this.totalSnapshotsDeleted = value;
            return this;
        }

        public Builder totalSnapshotDeletionFailures(long value) {
            this.totalSnapshotDeletionFailures = value;
            return this;
        }

        public Builder totalSnapshotsFailed(long value) {
            this.totalSnapshotsFailed = value;
            return this;
        }

        public Builder totalSnapshotsTaken(long value) {
            this.totalSnapshotsTaken = value;
            return this;
        }

        public Builder policyStats(List<String> value) {
            this.policyStats = value;
            return this;
        }

        public Builder policyStats(String ... value) {
            this.policyStats = Arrays.asList(value);
            return this;
        }

        public Builder addPolicyStats(String value) {
            if (this.policyStats == null) {
                this.policyStats = new ArrayList<String>();
            }
            this.policyStats.add(value);
            return this;
        }

        @Override
        public GetStatsResponse build() {
            return new GetStatsResponse(this);
        }
    }
}

