/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Configuration
implements JsonpSerializable {
    @Nullable
    private final Boolean ignoreUnavailable;
    private final List<String> indices;
    @Nullable
    private final Boolean includeGlobalState;
    @Nullable
    private final List<String> featureStates;
    @Nullable
    private final Map<String, JsonData> metadata;
    @Nullable
    private final Boolean partial;
    public static final JsonpDeserializer<Configuration> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Configuration::setupConfigurationDeserializer, Builder::build);

    public Configuration(Builder builder) {
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
        this.includeGlobalState = builder.includeGlobalState;
        this.featureStates = ModelTypeHelper.unmodifiable(builder.featureStates);
        this.metadata = ModelTypeHelper.unmodifiable(builder.metadata);
        this.partial = builder.partial;
    }

    public Configuration(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public List<String> indices() {
        return this.indices;
    }

    @Nullable
    public Boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    @Nullable
    public List<String> featureStates() {
        return this.featureStates;
    }

    @Nullable
    public Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public Boolean partial() {
        return this.partial;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.ignoreUnavailable != null) {
            generator.writeKey("ignore_unavailable");
            generator.write(this.ignoreUnavailable.booleanValue());
        }
        generator.writeKey("indices");
        generator.writeStartArray();
        for (String string : this.indices) {
            generator.write(string);
        }
        generator.writeEnd();
        if (this.includeGlobalState != null) {
            generator.writeKey("include_global_state");
            generator.write(this.includeGlobalState.booleanValue());
        }
        if (this.featureStates != null) {
            generator.writeKey("feature_states");
            generator.writeStartArray();
            for (String string : this.featureStates) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.metadata != null) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.partial != null) {
            generator.writeKey("partial");
            generator.write(this.partial.booleanValue());
        }
    }

    protected static void setupConfigurationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::ignoreUnavailable, JsonpDeserializer.booleanDeserializer(), "ignore_unavailable", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices", new String[0]);
        op.add(Builder::includeGlobalState, JsonpDeserializer.booleanDeserializer(), "include_global_state", new String[0]);
        op.add(Builder::featureStates, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "feature_states", new String[0]);
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata", new String[0]);
        op.add(Builder::partial, JsonpDeserializer.booleanDeserializer(), "partial", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Configuration> {
        @Nullable
        private Boolean ignoreUnavailable;
        private List<String> indices;
        @Nullable
        private Boolean includeGlobalState;
        @Nullable
        private List<String> featureStates;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private Boolean partial;

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder indices(List<String> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(String ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(String value) {
            if (this.indices == null) {
                this.indices = new ArrayList<String>();
            }
            this.indices.add(value);
            return this;
        }

        public Builder includeGlobalState(@Nullable Boolean value) {
            this.includeGlobalState = value;
            return this;
        }

        public Builder featureStates(@Nullable List<String> value) {
            this.featureStates = value;
            return this;
        }

        public Builder featureStates(String ... value) {
            this.featureStates = Arrays.asList(value);
            return this;
        }

        public Builder addFeatureStates(String value) {
            if (this.featureStates == null) {
                this.featureStates = new ArrayList<String>();
            }
            this.featureStates.add(value);
            return this;
        }

        public Builder metadata(@Nullable Map<String, JsonData> value) {
            this.metadata = value;
            return this;
        }

        public Builder putMetadata(String key, JsonData value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, JsonData>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder partial(@Nullable Boolean value) {
            this.partial = value;
            return this;
        }

        @Override
        public Configuration build() {
            return new Configuration(this);
        }
    }
}

