/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.PutRoleMappingResponse;
import co.elastic.clients.elasticsearch.security.RoleMappingRule;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutRoleMappingRequest
extends RequestBase
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final JsonValue refresh;
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final Map<String, JsonData> metadata;
    @Nullable
    private final List<String> roles;
    @Nullable
    private final RoleMappingRule rules;
    @Nullable
    private final List<String> runAs;
    public static final JsonpDeserializer<PutRoleMappingRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutRoleMappingRequest::setupPutRoleMappingRequestDeserializer, Builder::build);
    public static final Endpoint<PutRoleMappingRequest, PutRoleMappingResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutRoleMappingRequest, PutRoleMappingResponse>(request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/role_mapping");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", JsonpUtils.toString(request.refresh));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutRoleMappingResponse._DESERIALIZER);

    public PutRoleMappingRequest(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.refresh = builder.refresh;
        this.enabled = builder.enabled;
        this.metadata = ModelTypeHelper.unmodifiable(builder.metadata);
        this.roles = ModelTypeHelper.unmodifiable(builder.roles);
        this.rules = builder.rules;
        this.runAs = ModelTypeHelper.unmodifiable(builder.runAs);
    }

    public PutRoleMappingRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public JsonValue refresh() {
        return this.refresh;
    }

    @Nullable
    public Boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public List<String> roles() {
        return this.roles;
    }

    @Nullable
    public RoleMappingRule rules() {
        return this.rules;
    }

    @Nullable
    public List<String> runAs() {
        return this.runAs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
        if (this.metadata != null) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.roles != null) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (String string : this.roles) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.rules != null) {
            generator.writeKey("rules");
            this.rules.serialize(generator, mapper);
        }
        if (this.runAs != null) {
            generator.writeKey("run_as");
            generator.writeStartArray();
            for (String string : this.runAs) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutRoleMappingRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled", new String[0]);
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata", new String[0]);
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles", new String[0]);
        op.add(Builder::rules, RoleMappingRule._DESERIALIZER, "rules", new String[0]);
        op.add(Builder::runAs, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "run_as", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutRoleMappingRequest> {
        private String name;
        @Nullable
        private JsonValue refresh;
        @Nullable
        private Boolean enabled;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private List<String> roles;
        @Nullable
        private RoleMappingRule rules;
        @Nullable
        private List<String> runAs;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder refresh(@Nullable JsonValue value) {
            this.refresh = value;
            return this;
        }

        public Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        public Builder metadata(@Nullable Map<String, JsonData> value) {
            this.metadata = value;
            return this;
        }

        public Builder putMetadata(String key, JsonData value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, JsonData>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder roles(@Nullable List<String> value) {
            this.roles = value;
            return this;
        }

        public Builder roles(String ... value) {
            this.roles = Arrays.asList(value);
            return this;
        }

        public Builder addRoles(String value) {
            if (this.roles == null) {
                this.roles = new ArrayList<String>();
            }
            this.roles.add(value);
            return this;
        }

        public Builder rules(@Nullable RoleMappingRule value) {
            this.rules = value;
            return this;
        }

        public Builder rules(Function<RoleMappingRule.Builder, ObjectBuilder<RoleMappingRule>> fn) {
            return this.rules(fn.apply(new RoleMappingRule.Builder()).build());
        }

        public Builder runAs(@Nullable List<String> value) {
            this.runAs = value;
            return this;
        }

        public Builder runAs(String ... value) {
            this.runAs = Arrays.asList(value);
            return this;
        }

        public Builder addRunAs(String value) {
            if (this.runAs == null) {
                this.runAs = new ArrayList<String>();
            }
            this.runAs.add(value);
            return this;
        }

        @Override
        public PutRoleMappingRequest build() {
            return new PutRoleMappingRequest(this);
        }
    }
}

