/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.ClusterPrivilege;
import co.elastic.clients.elasticsearch.security.HasPrivilegesResponse;
import co.elastic.clients.elasticsearch.security.has_privileges.ApplicationPrivilegesCheck;
import co.elastic.clients.elasticsearch.security.has_privileges.IndexPrivilegesCheck;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class HasPrivilegesRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String user;
    @Nullable
    private final List<ApplicationPrivilegesCheck> application;
    @Nullable
    private final List<ClusterPrivilege> cluster;
    @Nullable
    private final List<IndexPrivilegesCheck> index;
    public static final JsonpDeserializer<HasPrivilegesRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HasPrivilegesRequest::setupHasPrivilegesRequestDeserializer, Builder::build);
    public static final Endpoint<HasPrivilegesRequest, HasPrivilegesResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<HasPrivilegesRequest, HasPrivilegesResponse>(request -> "POST", request -> {
        boolean _user = true;
        boolean propsSet = false;
        if (request.user() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/user");
            buf.append("/_has_privileges");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/user");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.user, buf);
            buf.append("/_has_privileges");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, HasPrivilegesResponse._DESERIALIZER);

    public HasPrivilegesRequest(Builder builder) {
        this.user = builder.user;
        this.application = ModelTypeHelper.unmodifiable(builder.application);
        this.cluster = ModelTypeHelper.unmodifiable(builder.cluster);
        this.index = ModelTypeHelper.unmodifiable(builder.index);
    }

    public HasPrivilegesRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String user() {
        return this.user;
    }

    @Nullable
    public List<ApplicationPrivilegesCheck> application() {
        return this.application;
    }

    @Nullable
    public List<ClusterPrivilege> cluster() {
        return this.cluster;
    }

    @Nullable
    public List<IndexPrivilegesCheck> index() {
        return this.index;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.application != null) {
            generator.writeKey("application");
            generator.writeStartArray();
            for (ApplicationPrivilegesCheck applicationPrivilegesCheck : this.application) {
                applicationPrivilegesCheck.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.cluster != null) {
            generator.writeKey("cluster");
            generator.writeStartArray();
            for (ClusterPrivilege clusterPrivilege : this.cluster) {
                clusterPrivilege.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.writeStartArray();
            for (IndexPrivilegesCheck indexPrivilegesCheck : this.index) {
                indexPrivilegesCheck.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupHasPrivilegesRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::application, JsonpDeserializer.arrayDeserializer(ApplicationPrivilegesCheck._DESERIALIZER), "application", new String[0]);
        op.add(Builder::cluster, JsonpDeserializer.arrayDeserializer(ClusterPrivilege._DESERIALIZER), "cluster", new String[0]);
        op.add(Builder::index, JsonpDeserializer.arrayDeserializer(IndexPrivilegesCheck._DESERIALIZER), "index", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<HasPrivilegesRequest> {
        @Nullable
        private String user;
        @Nullable
        private List<ApplicationPrivilegesCheck> application;
        @Nullable
        private List<ClusterPrivilege> cluster;
        @Nullable
        private List<IndexPrivilegesCheck> index;

        public Builder user(@Nullable String value) {
            this.user = value;
            return this;
        }

        public Builder application(@Nullable List<ApplicationPrivilegesCheck> value) {
            this.application = value;
            return this;
        }

        public Builder application(ApplicationPrivilegesCheck ... value) {
            this.application = Arrays.asList(value);
            return this;
        }

        public Builder addApplication(ApplicationPrivilegesCheck value) {
            if (this.application == null) {
                this.application = new ArrayList<ApplicationPrivilegesCheck>();
            }
            this.application.add(value);
            return this;
        }

        public Builder application(Function<ApplicationPrivilegesCheck.Builder, ObjectBuilder<ApplicationPrivilegesCheck>> fn) {
            return this.application(fn.apply(new ApplicationPrivilegesCheck.Builder()).build());
        }

        public Builder addApplication(Function<ApplicationPrivilegesCheck.Builder, ObjectBuilder<ApplicationPrivilegesCheck>> fn) {
            return this.addApplication(fn.apply(new ApplicationPrivilegesCheck.Builder()).build());
        }

        public Builder cluster(@Nullable List<ClusterPrivilege> value) {
            this.cluster = value;
            return this;
        }

        public Builder cluster(ClusterPrivilege ... value) {
            this.cluster = Arrays.asList(value);
            return this;
        }

        public Builder addCluster(ClusterPrivilege value) {
            if (this.cluster == null) {
                this.cluster = new ArrayList<ClusterPrivilege>();
            }
            this.cluster.add(value);
            return this;
        }

        public Builder index(@Nullable List<IndexPrivilegesCheck> value) {
            this.index = value;
            return this;
        }

        public Builder index(IndexPrivilegesCheck ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(IndexPrivilegesCheck value) {
            if (this.index == null) {
                this.index = new ArrayList<IndexPrivilegesCheck>();
            }
            this.index.add(value);
            return this;
        }

        public Builder index(Function<IndexPrivilegesCheck.Builder, ObjectBuilder<IndexPrivilegesCheck>> fn) {
            return this.index(fn.apply(new IndexPrivilegesCheck.Builder()).build());
        }

        public Builder addIndex(Function<IndexPrivilegesCheck.Builder, ObjectBuilder<IndexPrivilegesCheck>> fn) {
            return this.addIndex(fn.apply(new IndexPrivilegesCheck.Builder()).build());
        }

        @Override
        public HasPrivilegesRequest build() {
            return new HasPrivilegesRequest(this);
        }
    }
}

