/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.CreateApiKeyResponse;
import co.elastic.clients.elasticsearch.security.create_api_key.RoleDescriptor;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CreateApiKeyRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final JsonValue refresh;
    @Nullable
    private final String expiration;
    @Nullable
    private final String name;
    @Nullable
    private final Map<String, RoleDescriptor> roleDescriptors;
    @Nullable
    private final Map<String, JsonData> metadata;
    public static final JsonpDeserializer<CreateApiKeyRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateApiKeyRequest::setupCreateApiKeyRequestDeserializer, Builder::build);
    public static final Endpoint<CreateApiKeyRequest, CreateApiKeyResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<CreateApiKeyRequest, CreateApiKeyResponse>(request -> "PUT", request -> "/_security/api_key", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", JsonpUtils.toString(request.refresh));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, CreateApiKeyResponse._DESERIALIZER);

    public CreateApiKeyRequest(Builder builder) {
        this.refresh = builder.refresh;
        this.expiration = builder.expiration;
        this.name = builder.name;
        this.roleDescriptors = ModelTypeHelper.unmodifiable(builder.roleDescriptors);
        this.metadata = ModelTypeHelper.unmodifiable(builder.metadata);
    }

    public CreateApiKeyRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public JsonValue refresh() {
        return this.refresh;
    }

    @Nullable
    public String expiration() {
        return this.expiration;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Nullable
    public Map<String, RoleDescriptor> roleDescriptors() {
        return this.roleDescriptors;
    }

    @Nullable
    public Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.expiration != null) {
            generator.writeKey("expiration");
            generator.write(this.expiration);
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.roleDescriptors != null) {
            generator.writeKey("role_descriptors");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.roleDescriptors.entrySet()) {
                generator.writeKey(entry.getKey());
                ((RoleDescriptor)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.metadata != null) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.metadata.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupCreateApiKeyRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::expiration, JsonpDeserializer.stringDeserializer(), "expiration", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::roleDescriptors, JsonpDeserializer.stringMapDeserializer(RoleDescriptor._DESERIALIZER), "role_descriptors", new String[0]);
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CreateApiKeyRequest> {
        @Nullable
        private JsonValue refresh;
        @Nullable
        private String expiration;
        @Nullable
        private String name;
        @Nullable
        private Map<String, RoleDescriptor> roleDescriptors;
        @Nullable
        private Map<String, JsonData> metadata;

        public Builder refresh(@Nullable JsonValue value) {
            this.refresh = value;
            return this;
        }

        public Builder expiration(@Nullable String value) {
            this.expiration = value;
            return this;
        }

        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public Builder roleDescriptors(@Nullable Map<String, RoleDescriptor> value) {
            this.roleDescriptors = value;
            return this;
        }

        public Builder putRoleDescriptors(String key, RoleDescriptor value) {
            if (this.roleDescriptors == null) {
                this.roleDescriptors = new HashMap<String, RoleDescriptor>();
            }
            this.roleDescriptors.put(key, value);
            return this;
        }

        public Builder roleDescriptors(String key, Function<RoleDescriptor.Builder, ObjectBuilder<RoleDescriptor>> fn) {
            return this.roleDescriptors(Collections.singletonMap(key, fn.apply(new RoleDescriptor.Builder()).build()));
        }

        public Builder putRoleDescriptors(String key, Function<RoleDescriptor.Builder, ObjectBuilder<RoleDescriptor>> fn) {
            return this.putRoleDescriptors(key, fn.apply(new RoleDescriptor.Builder()).build());
        }

        public Builder metadata(@Nullable Map<String, JsonData> value) {
            this.metadata = value;
            return this;
        }

        public Builder putMetadata(String key, JsonData value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, JsonData>();
            }
            this.metadata.put(key, value);
            return this;
        }

        @Override
        public CreateApiKeyRequest build() {
            return new CreateApiKeyRequest(this);
        }
    }
}

