/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup.get_rollup_caps;

import co.elastic.clients.elasticsearch.rollup.get_rollup_caps.RollupCapabilitySummary;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class RollupCapabilities
implements JsonpSerializable {
    private final List<RollupCapabilitySummary> rollupJobs;
    public static final JsonpDeserializer<RollupCapabilities> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RollupCapabilities::setupRollupCapabilitiesDeserializer, Builder::build);

    public RollupCapabilities(Builder builder) {
        this.rollupJobs = ModelTypeHelper.unmodifiableNonNull(builder.rollupJobs, "rollup_jobs");
    }

    public RollupCapabilities(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<RollupCapabilitySummary> rollupJobs() {
        return this.rollupJobs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("rollup_jobs");
        generator.writeStartArray();
        for (RollupCapabilitySummary item0 : this.rollupJobs) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupRollupCapabilitiesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::rollupJobs, JsonpDeserializer.arrayDeserializer(RollupCapabilitySummary._DESERIALIZER), "rollup_jobs", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RollupCapabilities> {
        private List<RollupCapabilitySummary> rollupJobs;

        public Builder rollupJobs(List<RollupCapabilitySummary> value) {
            this.rollupJobs = value;
            return this;
        }

        public Builder rollupJobs(RollupCapabilitySummary ... value) {
            this.rollupJobs = Arrays.asList(value);
            return this;
        }

        public Builder addRollupJobs(RollupCapabilitySummary value) {
            if (this.rollupJobs == null) {
                this.rollupJobs = new ArrayList<RollupCapabilitySummary>();
            }
            this.rollupJobs.add(value);
            return this;
        }

        public Builder rollupJobs(Function<RollupCapabilitySummary.Builder, ObjectBuilder<RollupCapabilitySummary>> fn) {
            return this.rollupJobs(fn.apply(new RollupCapabilitySummary.Builder()).build());
        }

        public Builder addRollupJobs(Function<RollupCapabilitySummary.Builder, ObjectBuilder<RollupCapabilitySummary>> fn) {
            return this.addRollupJobs(fn.apply(new RollupCapabilitySummary.Builder()).build());
        }

        @Override
        public RollupCapabilities build() {
            return new RollupCapabilities(this);
        }
    }
}

