/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.elasticsearch.rollup.Metric;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class FieldMetric
implements JsonpSerializable {
    private final String field;
    private final List<Metric> metrics;
    public static final JsonpDeserializer<FieldMetric> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldMetric::setupFieldMetricDeserializer, Builder::build);

    public FieldMetric(Builder builder) {
        this.field = Objects.requireNonNull(builder.field, "field");
        this.metrics = ModelTypeHelper.unmodifiableNonNull(builder.metrics, "metrics");
    }

    public FieldMetric(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String field() {
        return this.field;
    }

    public List<Metric> metrics() {
        return this.metrics;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("metrics");
        generator.writeStartArray();
        for (Metric item0 : this.metrics) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupFieldMetricDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::metrics, JsonpDeserializer.arrayDeserializer(Metric._DESERIALIZER), "metrics", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FieldMetric> {
        private String field;
        private List<Metric> metrics;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder metrics(List<Metric> value) {
            this.metrics = value;
            return this;
        }

        public Builder metrics(Metric ... value) {
            this.metrics = Arrays.asList(value);
            return this;
        }

        public Builder addMetrics(Metric value) {
            if (this.metrics == null) {
                this.metrics = new ArrayList<Metric>();
            }
            this.metrics.add(value);
            return this;
        }

        @Override
        public FieldMetric build() {
            return new FieldMetric(this);
        }
    }
}

