/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.base.ApiClient;
import co.elastic.clients.base.Transport;
import co.elastic.clients.elasticsearch.rollup.DeleteJobRequest;
import co.elastic.clients.elasticsearch.rollup.DeleteJobResponse;
import co.elastic.clients.elasticsearch.rollup.GetJobsRequest;
import co.elastic.clients.elasticsearch.rollup.GetJobsResponse;
import co.elastic.clients.elasticsearch.rollup.GetRollupCapsRequest;
import co.elastic.clients.elasticsearch.rollup.GetRollupCapsResponse;
import co.elastic.clients.elasticsearch.rollup.GetRollupIndexCapsRequest;
import co.elastic.clients.elasticsearch.rollup.GetRollupIndexCapsResponse;
import co.elastic.clients.elasticsearch.rollup.PutJobRequest;
import co.elastic.clients.elasticsearch.rollup.PutJobResponse;
import co.elastic.clients.elasticsearch.rollup.RollupRequest;
import co.elastic.clients.elasticsearch.rollup.RollupResponse;
import co.elastic.clients.elasticsearch.rollup.RollupSearchRequest;
import co.elastic.clients.elasticsearch.rollup.RollupSearchResponse;
import co.elastic.clients.elasticsearch.rollup.StartJobRequest;
import co.elastic.clients.elasticsearch.rollup.StartJobResponse;
import co.elastic.clients.elasticsearch.rollup.StopJobRequest;
import co.elastic.clients.elasticsearch.rollup.StopJobResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.util.function.Function;

public class ElasticsearchRollupClient
extends ApiClient {
    public ElasticsearchRollupClient(Transport transport) {
        super(transport);
    }

    public DeleteJobResponse deleteJob(DeleteJobRequest request) throws IOException {
        return this.transport.performRequest(request, DeleteJobRequest.ENDPOINT);
    }

    public final DeleteJobResponse deleteJob(Function<DeleteJobRequest.Builder, ObjectBuilder<DeleteJobRequest>> fn) throws IOException {
        return this.deleteJob(fn.apply(new DeleteJobRequest.Builder()).build());
    }

    public GetJobsResponse getJobs(GetJobsRequest request) throws IOException {
        return this.transport.performRequest(request, GetJobsRequest.ENDPOINT);
    }

    public final GetJobsResponse getJobs(Function<GetJobsRequest.Builder, ObjectBuilder<GetJobsRequest>> fn) throws IOException {
        return this.getJobs(fn.apply(new GetJobsRequest.Builder()).build());
    }

    public GetJobsResponse getJobs() throws IOException {
        return this.transport.performRequest(new GetJobsRequest.Builder().build(), GetJobsRequest.ENDPOINT);
    }

    public GetRollupCapsResponse getRollupCaps(GetRollupCapsRequest request) throws IOException {
        return this.transport.performRequest(request, GetRollupCapsRequest.ENDPOINT);
    }

    public final GetRollupCapsResponse getRollupCaps(Function<GetRollupCapsRequest.Builder, ObjectBuilder<GetRollupCapsRequest>> fn) throws IOException {
        return this.getRollupCaps(fn.apply(new GetRollupCapsRequest.Builder()).build());
    }

    public GetRollupCapsResponse getRollupCaps() throws IOException {
        return this.transport.performRequest(new GetRollupCapsRequest.Builder().build(), GetRollupCapsRequest.ENDPOINT);
    }

    public GetRollupIndexCapsResponse getRollupIndexCaps(GetRollupIndexCapsRequest request) throws IOException {
        return this.transport.performRequest(request, GetRollupIndexCapsRequest.ENDPOINT);
    }

    public final GetRollupIndexCapsResponse getRollupIndexCaps(Function<GetRollupIndexCapsRequest.Builder, ObjectBuilder<GetRollupIndexCapsRequest>> fn) throws IOException {
        return this.getRollupIndexCaps(fn.apply(new GetRollupIndexCapsRequest.Builder()).build());
    }

    public PutJobResponse putJob(PutJobRequest request) throws IOException {
        return this.transport.performRequest(request, PutJobRequest.ENDPOINT);
    }

    public final PutJobResponse putJob(Function<PutJobRequest.Builder, ObjectBuilder<PutJobRequest>> fn) throws IOException {
        return this.putJob(fn.apply(new PutJobRequest.Builder()).build());
    }

    public RollupResponse rollup(RollupRequest request) throws IOException {
        return this.transport.performRequest(request, RollupRequest.ENDPOINT);
    }

    public final RollupResponse rollup(Function<RollupRequest.Builder, ObjectBuilder<RollupRequest>> fn) throws IOException {
        return this.rollup(fn.apply(new RollupRequest.Builder()).build());
    }

    public <TDocument> RollupSearchResponse<TDocument> rollupSearch(RollupSearchRequest request, Class<TDocument> tDocumentClass) throws IOException {
        return this.transport.performRequest(request, RollupSearchRequest.createRollupSearchEndpoint(this.getDeserializer(tDocumentClass)));
    }

    public final <TDocument> RollupSearchResponse<TDocument> rollupSearch(Function<RollupSearchRequest.Builder, ObjectBuilder<RollupSearchRequest>> fn, Class<TDocument> tDocumentClass) throws IOException {
        return this.rollupSearch(fn.apply(new RollupSearchRequest.Builder()).build(), tDocumentClass);
    }

    public StartJobResponse startJob(StartJobRequest request) throws IOException {
        return this.transport.performRequest(request, StartJobRequest.ENDPOINT);
    }

    public final StartJobResponse startJob(Function<StartJobRequest.Builder, ObjectBuilder<StartJobRequest>> fn) throws IOException {
        return this.startJob(fn.apply(new StartJobRequest.Builder()).build());
    }

    public StopJobResponse stopJob(StopJobRequest request) throws IOException {
        return this.transport.performRequest(request, StopJobRequest.ENDPOINT);
    }

    public final StopJobResponse stopJob(Function<StopJobRequest.Builder, ObjectBuilder<StopJobRequest>> fn) throws IOException {
        return this.stopJob(fn.apply(new StopJobRequest.Builder()).build());
    }
}

