/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.GarbageCollector;
import co.elastic.clients.elasticsearch.nodes.JvmClasses;
import co.elastic.clients.elasticsearch.nodes.JvmThreads;
import co.elastic.clients.elasticsearch.nodes.MemoryStats;
import co.elastic.clients.elasticsearch.nodes.NodeBufferPool;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Jvm
implements JsonpSerializable {
    private final Map<String, NodeBufferPool> bufferPools;
    private final JvmClasses classes;
    private final GarbageCollector gc;
    private final MemoryStats mem;
    private final JvmThreads threads;
    private final long timestamp;
    private final String uptime;
    private final long uptimeInMillis;
    public static final JsonpDeserializer<Jvm> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Jvm::setupJvmDeserializer, Builder::build);

    public Jvm(Builder builder) {
        this.bufferPools = ModelTypeHelper.unmodifiableNonNull(builder.bufferPools, "buffer_pools");
        this.classes = Objects.requireNonNull(builder.classes, "classes");
        this.gc = Objects.requireNonNull(builder.gc, "gc");
        this.mem = Objects.requireNonNull(builder.mem, "mem");
        this.threads = Objects.requireNonNull(builder.threads, "threads");
        this.timestamp = Objects.requireNonNull(builder.timestamp, "timestamp");
        this.uptime = Objects.requireNonNull(builder.uptime, "uptime");
        this.uptimeInMillis = Objects.requireNonNull(builder.uptimeInMillis, "uptime_in_millis");
    }

    public Jvm(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, NodeBufferPool> bufferPools() {
        return this.bufferPools;
    }

    public JvmClasses classes() {
        return this.classes;
    }

    public GarbageCollector gc() {
        return this.gc;
    }

    public MemoryStats mem() {
        return this.mem;
    }

    public JvmThreads threads() {
        return this.threads;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public String uptime() {
        return this.uptime;
    }

    public long uptimeInMillis() {
        return this.uptimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("buffer_pools");
        generator.writeStartObject();
        for (Map.Entry<String, NodeBufferPool> item0 : this.bufferPools.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("classes");
        this.classes.serialize(generator, mapper);
        generator.writeKey("gc");
        this.gc.serialize(generator, mapper);
        generator.writeKey("mem");
        this.mem.serialize(generator, mapper);
        generator.writeKey("threads");
        this.threads.serialize(generator, mapper);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
        generator.writeKey("uptime");
        generator.write(this.uptime);
        generator.writeKey("uptime_in_millis");
        generator.write(this.uptimeInMillis);
    }

    protected static void setupJvmDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::bufferPools, JsonpDeserializer.stringMapDeserializer(NodeBufferPool._DESERIALIZER), "buffer_pools", new String[0]);
        op.add(Builder::classes, JvmClasses._DESERIALIZER, "classes", new String[0]);
        op.add(Builder::gc, GarbageCollector._DESERIALIZER, "gc", new String[0]);
        op.add(Builder::mem, MemoryStats._DESERIALIZER, "mem", new String[0]);
        op.add(Builder::threads, JvmThreads._DESERIALIZER, "threads", new String[0]);
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp", new String[0]);
        op.add(Builder::uptime, JsonpDeserializer.stringDeserializer(), "uptime", new String[0]);
        op.add(Builder::uptimeInMillis, JsonpDeserializer.longDeserializer(), "uptime_in_millis", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Jvm> {
        private Map<String, NodeBufferPool> bufferPools;
        private JvmClasses classes;
        private GarbageCollector gc;
        private MemoryStats mem;
        private JvmThreads threads;
        private Long timestamp;
        private String uptime;
        private Long uptimeInMillis;

        public Builder bufferPools(Map<String, NodeBufferPool> value) {
            this.bufferPools = value;
            return this;
        }

        public Builder putBufferPools(String key, NodeBufferPool value) {
            if (this.bufferPools == null) {
                this.bufferPools = new HashMap<String, NodeBufferPool>();
            }
            this.bufferPools.put(key, value);
            return this;
        }

        public Builder bufferPools(String key, Function<NodeBufferPool.Builder, ObjectBuilder<NodeBufferPool>> fn) {
            return this.bufferPools(Collections.singletonMap(key, fn.apply(new NodeBufferPool.Builder()).build()));
        }

        public Builder putBufferPools(String key, Function<NodeBufferPool.Builder, ObjectBuilder<NodeBufferPool>> fn) {
            return this.putBufferPools(key, fn.apply(new NodeBufferPool.Builder()).build());
        }

        public Builder classes(JvmClasses value) {
            this.classes = value;
            return this;
        }

        public Builder classes(Function<JvmClasses.Builder, ObjectBuilder<JvmClasses>> fn) {
            return this.classes(fn.apply(new JvmClasses.Builder()).build());
        }

        public Builder gc(GarbageCollector value) {
            this.gc = value;
            return this;
        }

        public Builder gc(Function<GarbageCollector.Builder, ObjectBuilder<GarbageCollector>> fn) {
            return this.gc(fn.apply(new GarbageCollector.Builder()).build());
        }

        public Builder mem(MemoryStats value) {
            this.mem = value;
            return this;
        }

        public Builder mem(Function<MemoryStats.Builder, ObjectBuilder<MemoryStats>> fn) {
            return this.mem(fn.apply(new MemoryStats.Builder()).build());
        }

        public Builder threads(JvmThreads value) {
            this.threads = value;
            return this;
        }

        public Builder threads(Function<JvmThreads.Builder, ObjectBuilder<JvmThreads>> fn) {
            return this.threads(fn.apply(new JvmThreads.Builder()).build());
        }

        public Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        public Builder uptime(String value) {
            this.uptime = value;
            return this;
        }

        public Builder uptimeInMillis(long value) {
            this.uptimeInMillis = value;
            return this;
        }

        @Override
        public Jvm build() {
            return new Jvm(this);
        }
    }
}

