/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.monitoring;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.core.bulk.Operation;
import co.elastic.clients.elasticsearch.monitoring.BulkResponse;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.NdJsonpSerializable;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class BulkRequest<TSource>
extends RequestBase
implements NdJsonpSerializable<Object>,
JsonpSerializable {
    @Nullable
    private final String type;
    private final String systemId;
    private final String systemApiVersion;
    private final String interval;
    private final List<Object> operations;
    @Nullable
    private final JsonpSerializer<TSource> tSourceSerializer;
    public static final Endpoint<BulkRequest<?>, BulkResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<BulkRequest, BulkResponse>(request -> "POST", request -> {
        boolean _type = true;
        boolean propsSet = false;
        if (request.type() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_monitoring");
            buf.append("/bulk");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_monitoring");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/bulk");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("system_id", request.systemId);
        params.put("system_api_version", request.systemApiVersion);
        params.put("interval", request.interval);
        return params;
    }, SimpleEndpoint.emptyMap(), true, BulkResponse._DESERIALIZER);

    public BulkRequest(Builder<TSource> builder) {
        this.type = ((Builder)builder).type;
        this.systemId = Objects.requireNonNull(((Builder)builder).systemId, "system_id");
        this.systemApiVersion = Objects.requireNonNull(((Builder)builder).systemApiVersion, "system_api_version");
        this.interval = Objects.requireNonNull(((Builder)builder).interval, "interval");
        this.operations = ModelTypeHelper.unmodifiableNonNull(((Builder)builder).operations, "_value_body");
        this.tSourceSerializer = ((Builder)builder).tSourceSerializer;
    }

    public BulkRequest(Function<Builder<TSource>, Builder<TSource>> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String type() {
        return this.type;
    }

    public String systemId() {
        return this.systemId;
    }

    public String systemApiVersion() {
        return this.systemApiVersion;
    }

    public String interval() {
        return this.interval;
    }

    public List<Object> operations() {
        return this.operations;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.operations.iterator();
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (Object item0 : this.operations) {
            mapper.serialize(item0, generator);
        }
        generator.writeEnd();
    }

    public static class Builder<TSource>
    implements ObjectBuilder<BulkRequest<TSource>> {
        @Nullable
        private String type;
        private String systemId;
        private String systemApiVersion;
        private String interval;
        private List<Object> operations;
        @Nullable
        private JsonpSerializer<TSource> tSourceSerializer;

        public Builder<TSource> type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public Builder<TSource> systemId(String value) {
            this.systemId = value;
            return this;
        }

        public Builder<TSource> systemApiVersion(String value) {
            this.systemApiVersion = value;
            return this;
        }

        public Builder<TSource> interval(String value) {
            this.interval = value;
            return this;
        }

        public Builder<TSource> operations(List<Object> value) {
            this.operations = value;
            return this;
        }

        public Builder<TSource> operations(Object ... value) {
            this.operations = Arrays.asList(value);
            return this;
        }

        public Builder<TSource> addOperation(Operation value) {
            if (this.operations == null) {
                this.operations = new ArrayList<Object>();
            }
            this.operations.add(value);
            return this;
        }

        public Builder<TSource> addDocument(TSource value) {
            if (this.operations == null) {
                this.operations = new ArrayList<Object>();
            }
            this.operations.add(value);
            return this;
        }

        public Builder<TSource> addOperation(Function<Operation.Builder, ObjectBuilder<Operation>> fn) {
            return this.addOperation(fn.apply(new Operation.Builder()).build());
        }

        public Builder<TSource> tSourceSerializer(@Nullable JsonpSerializer<TSource> value) {
            this.tSourceSerializer = value;
            return this;
        }

        @Override
        public BulkRequest<TSource> build() {
            return new BulkRequest(this);
        }
    }
}

