/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.put_trained_model;

import co.elastic.clients.elasticsearch.ml.put_trained_model.PreprocessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class TargetMeanEncodingPreprocessor
implements PreprocessorVariant,
JsonpSerializable {
    private final String field;
    private final String featureName;
    private final Map<String, Double> targetMap;
    private final double defaultValue;
    public static final JsonpDeserializer<TargetMeanEncodingPreprocessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TargetMeanEncodingPreprocessor::setupTargetMeanEncodingPreprocessorDeserializer, Builder::build);

    public TargetMeanEncodingPreprocessor(Builder builder) {
        this.field = Objects.requireNonNull(builder.field, "field");
        this.featureName = Objects.requireNonNull(builder.featureName, "feature_name");
        this.targetMap = ModelTypeHelper.unmodifiableNonNull(builder.targetMap, "target_map");
        this.defaultValue = Objects.requireNonNull(builder.defaultValue, "default_value");
    }

    public TargetMeanEncodingPreprocessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "target_mean_encoding";
    }

    public String field() {
        return this.field;
    }

    public String featureName() {
        return this.featureName;
    }

    public Map<String, Double> targetMap() {
        return this.targetMap;
    }

    public double defaultValue() {
        return this.defaultValue;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("feature_name");
        generator.write(this.featureName);
        generator.writeKey("target_map");
        generator.writeStartObject();
        for (Map.Entry<String, Double> item0 : this.targetMap.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.write(item0.getValue().doubleValue());
        }
        generator.writeEnd();
        generator.writeKey("default_value");
        generator.write(this.defaultValue);
    }

    protected static void setupTargetMeanEncodingPreprocessorDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::featureName, JsonpDeserializer.stringDeserializer(), "feature_name", new String[0]);
        op.add(Builder::targetMap, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "target_map", new String[0]);
        op.add(Builder::defaultValue, JsonpDeserializer.doubleDeserializer(), "default_value", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TargetMeanEncodingPreprocessor> {
        private String field;
        private String featureName;
        private Map<String, Double> targetMap;
        private Double defaultValue;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder featureName(String value) {
            this.featureName = value;
            return this;
        }

        public Builder targetMap(Map<String, Double> value) {
            this.targetMap = value;
            return this;
        }

        public Builder putTargetMap(String key, Double value) {
            if (this.targetMap == null) {
                this.targetMap = new HashMap<String, Double>();
            }
            this.targetMap.put(key, value);
            return this;
        }

        public Builder defaultValue(double value) {
            this.defaultValue = value;
            return this;
        }

        @Override
        public TargetMeanEncodingPreprocessor build() {
            return new TargetMeanEncodingPreprocessor(this);
        }
    }
}

