/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.info;

import co.elastic.clients.elasticsearch.ml.CategorizationAnalyzer;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class AnomalyDetectors
implements JsonpSerializable {
    private final CategorizationAnalyzer categorizationAnalyzer;
    private final int categorizationExamplesLimit;
    private final String modelMemoryLimit;
    private final int modelSnapshotRetentionDays;
    private final int dailyModelSnapshotRetentionAfterDays;
    public static final JsonpDeserializer<AnomalyDetectors> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnomalyDetectors::setupAnomalyDetectorsDeserializer, Builder::build);

    public AnomalyDetectors(Builder builder) {
        this.categorizationAnalyzer = Objects.requireNonNull(builder.categorizationAnalyzer, "categorization_analyzer");
        this.categorizationExamplesLimit = Objects.requireNonNull(builder.categorizationExamplesLimit, "categorization_examples_limit");
        this.modelMemoryLimit = Objects.requireNonNull(builder.modelMemoryLimit, "model_memory_limit");
        this.modelSnapshotRetentionDays = Objects.requireNonNull(builder.modelSnapshotRetentionDays, "model_snapshot_retention_days");
        this.dailyModelSnapshotRetentionAfterDays = Objects.requireNonNull(builder.dailyModelSnapshotRetentionAfterDays, "daily_model_snapshot_retention_after_days");
    }

    public AnomalyDetectors(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public CategorizationAnalyzer categorizationAnalyzer() {
        return this.categorizationAnalyzer;
    }

    public int categorizationExamplesLimit() {
        return this.categorizationExamplesLimit;
    }

    public String modelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    public int modelSnapshotRetentionDays() {
        return this.modelSnapshotRetentionDays;
    }

    public int dailyModelSnapshotRetentionAfterDays() {
        return this.dailyModelSnapshotRetentionAfterDays;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("categorization_analyzer");
        this.categorizationAnalyzer.serialize(generator, mapper);
        generator.writeKey("categorization_examples_limit");
        generator.write(this.categorizationExamplesLimit);
        generator.writeKey("model_memory_limit");
        generator.write(this.modelMemoryLimit);
        generator.writeKey("model_snapshot_retention_days");
        generator.write(this.modelSnapshotRetentionDays);
        generator.writeKey("daily_model_snapshot_retention_after_days");
        generator.write(this.dailyModelSnapshotRetentionAfterDays);
    }

    protected static void setupAnomalyDetectorsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::categorizationAnalyzer, CategorizationAnalyzer._DESERIALIZER, "categorization_analyzer", new String[0]);
        op.add(Builder::categorizationExamplesLimit, JsonpDeserializer.integerDeserializer(), "categorization_examples_limit", new String[0]);
        op.add(Builder::modelMemoryLimit, JsonpDeserializer.stringDeserializer(), "model_memory_limit", new String[0]);
        op.add(Builder::modelSnapshotRetentionDays, JsonpDeserializer.integerDeserializer(), "model_snapshot_retention_days", new String[0]);
        op.add(Builder::dailyModelSnapshotRetentionAfterDays, JsonpDeserializer.integerDeserializer(), "daily_model_snapshot_retention_after_days", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AnomalyDetectors> {
        private CategorizationAnalyzer categorizationAnalyzer;
        private Integer categorizationExamplesLimit;
        private String modelMemoryLimit;
        private Integer modelSnapshotRetentionDays;
        private Integer dailyModelSnapshotRetentionAfterDays;

        public Builder categorizationAnalyzer(CategorizationAnalyzer value) {
            this.categorizationAnalyzer = value;
            return this;
        }

        public Builder categorizationAnalyzer(Function<CategorizationAnalyzer.Builder, ObjectBuilder<CategorizationAnalyzer>> fn) {
            return this.categorizationAnalyzer(fn.apply(new CategorizationAnalyzer.Builder()).build());
        }

        public Builder categorizationExamplesLimit(int value) {
            this.categorizationExamplesLimit = value;
            return this;
        }

        public Builder modelMemoryLimit(String value) {
            this.modelMemoryLimit = value;
            return this;
        }

        public Builder modelSnapshotRetentionDays(int value) {
            this.modelSnapshotRetentionDays = value;
            return this;
        }

        public Builder dailyModelSnapshotRetentionAfterDays(int value) {
            this.dailyModelSnapshotRetentionAfterDays = value;
            return this;
        }

        @Override
        public AnomalyDetectors build() {
            return new AnomalyDetectors(this);
        }
    }
}

