/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.evaluate_data_frame;

import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.ConfusionMatrixThreshold;
import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.DataframeEvaluationSummaryAucRoc;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DataframeOutlierDetectionSummary
implements JsonpSerializable {
    @Nullable
    private final DataframeEvaluationSummaryAucRoc aucRoc;
    @Nullable
    private final Map<String, Double> precision;
    @Nullable
    private final Map<String, Double> recall;
    @Nullable
    private final Map<String, ConfusionMatrixThreshold> confusionMatrix;
    public static final JsonpDeserializer<DataframeOutlierDetectionSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeOutlierDetectionSummary::setupDataframeOutlierDetectionSummaryDeserializer, Builder::build);

    public DataframeOutlierDetectionSummary(Builder builder) {
        this.aucRoc = builder.aucRoc;
        this.precision = ModelTypeHelper.unmodifiable(builder.precision);
        this.recall = ModelTypeHelper.unmodifiable(builder.recall);
        this.confusionMatrix = ModelTypeHelper.unmodifiable(builder.confusionMatrix);
    }

    public DataframeOutlierDetectionSummary(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public DataframeEvaluationSummaryAucRoc aucRoc() {
        return this.aucRoc;
    }

    @Nullable
    public Map<String, Double> precision() {
        return this.precision;
    }

    @Nullable
    public Map<String, Double> recall() {
        return this.recall;
    }

    @Nullable
    public Map<String, ConfusionMatrixThreshold> confusionMatrix() {
        return this.confusionMatrix;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.aucRoc != null) {
            generator.writeKey("auc_roc");
            this.aucRoc.serialize(generator, mapper);
        }
        if (this.precision != null) {
            generator.writeKey("precision");
            generator.writeStartObject();
            for (Map.Entry<String, Double> entry : this.precision.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue().doubleValue());
            }
            generator.writeEnd();
        }
        if (this.recall != null) {
            generator.writeKey("recall");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.recall.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(((Double)entry.getValue()).doubleValue());
            }
            generator.writeEnd();
        }
        if (this.confusionMatrix != null) {
            generator.writeKey("confusion_matrix");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.confusionMatrix.entrySet()) {
                generator.writeKey(entry.getKey());
                ((ConfusionMatrixThreshold)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupDataframeOutlierDetectionSummaryDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aucRoc, DataframeEvaluationSummaryAucRoc._DESERIALIZER, "auc_roc", new String[0]);
        op.add(Builder::precision, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "precision", new String[0]);
        op.add(Builder::recall, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "recall", new String[0]);
        op.add(Builder::confusionMatrix, JsonpDeserializer.stringMapDeserializer(ConfusionMatrixThreshold._DESERIALIZER), "confusion_matrix", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataframeOutlierDetectionSummary> {
        @Nullable
        private DataframeEvaluationSummaryAucRoc aucRoc;
        @Nullable
        private Map<String, Double> precision;
        @Nullable
        private Map<String, Double> recall;
        @Nullable
        private Map<String, ConfusionMatrixThreshold> confusionMatrix;

        public Builder aucRoc(@Nullable DataframeEvaluationSummaryAucRoc value) {
            this.aucRoc = value;
            return this;
        }

        public Builder aucRoc(Function<DataframeEvaluationSummaryAucRoc.Builder, ObjectBuilder<DataframeEvaluationSummaryAucRoc>> fn) {
            return this.aucRoc(fn.apply(new DataframeEvaluationSummaryAucRoc.Builder()).build());
        }

        public Builder precision(@Nullable Map<String, Double> value) {
            this.precision = value;
            return this;
        }

        public Builder putPrecision(String key, Double value) {
            if (this.precision == null) {
                this.precision = new HashMap<String, Double>();
            }
            this.precision.put(key, value);
            return this;
        }

        public Builder recall(@Nullable Map<String, Double> value) {
            this.recall = value;
            return this;
        }

        public Builder putRecall(String key, Double value) {
            if (this.recall == null) {
                this.recall = new HashMap<String, Double>();
            }
            this.recall.put(key, value);
            return this;
        }

        public Builder confusionMatrix(@Nullable Map<String, ConfusionMatrixThreshold> value) {
            this.confusionMatrix = value;
            return this;
        }

        public Builder putConfusionMatrix(String key, ConfusionMatrixThreshold value) {
            if (this.confusionMatrix == null) {
                this.confusionMatrix = new HashMap<String, ConfusionMatrixThreshold>();
            }
            this.confusionMatrix.put(key, value);
            return this;
        }

        public Builder confusionMatrix(String key, Function<ConfusionMatrixThreshold.Builder, ObjectBuilder<ConfusionMatrixThreshold>> fn) {
            return this.confusionMatrix(Collections.singletonMap(key, fn.apply(new ConfusionMatrixThreshold.Builder()).build()));
        }

        public Builder putConfusionMatrix(String key, Function<ConfusionMatrixThreshold.Builder, ObjectBuilder<ConfusionMatrixThreshold>> fn) {
            return this.putConfusionMatrix(key, fn.apply(new ConfusionMatrixThreshold.Builder()).build());
        }

        @Override
        public DataframeOutlierDetectionSummary build() {
            return new DataframeOutlierDetectionSummary(this);
        }
    }
}

