/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class UpdateFilterResponse
implements JsonpSerializable {
    private final String description;
    private final String filterId;
    private final List<String> items;
    public static final JsonpDeserializer<UpdateFilterResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateFilterResponse::setupUpdateFilterResponseDeserializer, Builder::build);

    public UpdateFilterResponse(Builder builder) {
        this.description = Objects.requireNonNull(builder.description, "description");
        this.filterId = Objects.requireNonNull(builder.filterId, "filter_id");
        this.items = ModelTypeHelper.unmodifiableNonNull(builder.items, "items");
    }

    public UpdateFilterResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String description() {
        return this.description;
    }

    public String filterId() {
        return this.filterId;
    }

    public List<String> items() {
        return this.items;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("filter_id");
        generator.write(this.filterId);
        generator.writeKey("items");
        generator.writeStartArray();
        for (String item0 : this.items) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupUpdateFilterResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::filterId, JsonpDeserializer.stringDeserializer(), "filter_id", new String[0]);
        op.add(Builder::items, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "items", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<UpdateFilterResponse> {
        private String description;
        private String filterId;
        private List<String> items;

        public Builder description(String value) {
            this.description = value;
            return this;
        }

        public Builder filterId(String value) {
            this.filterId = value;
            return this;
        }

        public Builder items(List<String> value) {
            this.items = value;
            return this;
        }

        public Builder items(String ... value) {
            this.items = Arrays.asList(value);
            return this;
        }

        public Builder addItems(String value) {
            if (this.items == null) {
                this.items = new ArrayList<String>();
            }
            this.items.add(value);
            return this;
        }

        @Override
        public UpdateFilterResponse build() {
            return new UpdateFilterResponse(this);
        }
    }
}

