/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class OverallBucketJob
implements JsonpSerializable {
    private final String jobId;
    private final double maxAnomalyScore;
    public static final JsonpDeserializer<OverallBucketJob> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OverallBucketJob::setupOverallBucketJobDeserializer, Builder::build);

    public OverallBucketJob(Builder builder) {
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.maxAnomalyScore = Objects.requireNonNull(builder.maxAnomalyScore, "max_anomaly_score");
    }

    public OverallBucketJob(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    public double maxAnomalyScore() {
        return this.maxAnomalyScore;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("max_anomaly_score");
        generator.write(this.maxAnomalyScore);
    }

    protected static void setupOverallBucketJobDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id", new String[0]);
        op.add(Builder::maxAnomalyScore, JsonpDeserializer.doubleDeserializer(), "max_anomaly_score", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<OverallBucketJob> {
        private String jobId;
        private Double maxAnomalyScore;

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder maxAnomalyScore(double value) {
            this.maxAnomalyScore = value;
            return this;
        }

        @Override
        public OverallBucketJob build() {
            return new OverallBucketJob(this);
        }
    }
}

