/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.info.Defaults;
import co.elastic.clients.elasticsearch.ml.info.Limits;
import co.elastic.clients.elasticsearch.ml.info.NativeCode;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class MlInfoResponse
implements JsonpSerializable {
    private final Defaults defaults;
    private final Limits limits;
    private final boolean upgradeMode;
    private final NativeCode nativeCode;
    public static final JsonpDeserializer<MlInfoResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MlInfoResponse::setupMlInfoResponseDeserializer, Builder::build);

    public MlInfoResponse(Builder builder) {
        this.defaults = Objects.requireNonNull(builder.defaults, "defaults");
        this.limits = Objects.requireNonNull(builder.limits, "limits");
        this.upgradeMode = Objects.requireNonNull(builder.upgradeMode, "upgrade_mode");
        this.nativeCode = Objects.requireNonNull(builder.nativeCode, "native_code");
    }

    public MlInfoResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Defaults defaults() {
        return this.defaults;
    }

    public Limits limits() {
        return this.limits;
    }

    public boolean upgradeMode() {
        return this.upgradeMode;
    }

    public NativeCode nativeCode() {
        return this.nativeCode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("defaults");
        this.defaults.serialize(generator, mapper);
        generator.writeKey("limits");
        this.limits.serialize(generator, mapper);
        generator.writeKey("upgrade_mode");
        generator.write(this.upgradeMode);
        generator.writeKey("native_code");
        this.nativeCode.serialize(generator, mapper);
    }

    protected static void setupMlInfoResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::defaults, Defaults._DESERIALIZER, "defaults", new String[0]);
        op.add(Builder::limits, Limits._DESERIALIZER, "limits", new String[0]);
        op.add(Builder::upgradeMode, JsonpDeserializer.booleanDeserializer(), "upgrade_mode", new String[0]);
        op.add(Builder::nativeCode, NativeCode._DESERIALIZER, "native_code", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<MlInfoResponse> {
        private Defaults defaults;
        private Limits limits;
        private Boolean upgradeMode;
        private NativeCode nativeCode;

        public Builder defaults(Defaults value) {
            this.defaults = value;
            return this;
        }

        public Builder defaults(Function<Defaults.Builder, ObjectBuilder<Defaults>> fn) {
            return this.defaults(fn.apply(new Defaults.Builder()).build());
        }

        public Builder limits(Limits value) {
            this.limits = value;
            return this;
        }

        public Builder limits(Function<Limits.Builder, ObjectBuilder<Limits>> fn) {
            return this.limits(fn.apply(new Limits.Builder()).build());
        }

        public Builder upgradeMode(boolean value) {
            this.upgradeMode = value;
            return this;
        }

        public Builder nativeCode(NativeCode value) {
            this.nativeCode = value;
            return this;
        }

        public Builder nativeCode(Function<NativeCode.Builder, ObjectBuilder<NativeCode>> fn) {
            return this.nativeCode(fn.apply(new NativeCode.Builder()).build());
        }

        @Override
        public MlInfoResponse build() {
            return new MlInfoResponse(this);
        }
    }
}

