/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.Datafeed;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GetDatafeedsResponse
implements JsonpSerializable {
    private final long count;
    private final List<Datafeed> datafeeds;
    public static final JsonpDeserializer<GetDatafeedsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetDatafeedsResponse::setupGetDatafeedsResponseDeserializer, Builder::build);

    public GetDatafeedsResponse(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.datafeeds = ModelTypeHelper.unmodifiableNonNull(builder.datafeeds, "datafeeds");
    }

    public GetDatafeedsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long count() {
        return this.count;
    }

    public List<Datafeed> datafeeds() {
        return this.datafeeds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("datafeeds");
        generator.writeStartArray();
        for (Datafeed item0 : this.datafeeds) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetDatafeedsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
        op.add(Builder::datafeeds, JsonpDeserializer.arrayDeserializer(Datafeed._DESERIALIZER), "datafeeds", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetDatafeedsResponse> {
        private Long count;
        private List<Datafeed> datafeeds;

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        public Builder datafeeds(List<Datafeed> value) {
            this.datafeeds = value;
            return this;
        }

        public Builder datafeeds(Datafeed ... value) {
            this.datafeeds = Arrays.asList(value);
            return this;
        }

        public Builder addDatafeeds(Datafeed value) {
            if (this.datafeeds == null) {
                this.datafeeds = new ArrayList<Datafeed>();
            }
            this.datafeeds.add(value);
            return this;
        }

        public Builder datafeeds(Function<Datafeed.Builder, ObjectBuilder<Datafeed>> fn) {
            return this.datafeeds(fn.apply(new Datafeed.Builder()).build());
        }

        public Builder addDatafeeds(Function<Datafeed.Builder, ObjectBuilder<Datafeed>> fn) {
            return this.addDatafeeds(fn.apply(new Datafeed.Builder()).build());
        }

        @Override
        public GetDatafeedsResponse build() {
            return new GetDatafeedsResponse(this);
        }
    }
}

