/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.ml.DataframeEvaluation;
import co.elastic.clients.elasticsearch.ml.EvaluateDataFrameResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class EvaluateDataFrameRequest
extends RequestBase
implements JsonpSerializable {
    private final DataframeEvaluation evaluation;
    private final String index;
    @Nullable
    private final Query query;
    public static final JsonpDeserializer<EvaluateDataFrameRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EvaluateDataFrameRequest::setupEvaluateDataFrameRequestDeserializer, Builder::build);
    public static final Endpoint<EvaluateDataFrameRequest, EvaluateDataFrameResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<EvaluateDataFrameRequest, EvaluateDataFrameResponse>(request -> "POST", request -> "/_ml/data_frame/_evaluate", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, EvaluateDataFrameResponse._DESERIALIZER);

    public EvaluateDataFrameRequest(Builder builder) {
        this.evaluation = Objects.requireNonNull(builder.evaluation, "evaluation");
        this.index = Objects.requireNonNull(builder.index, "index");
        this.query = builder.query;
    }

    public EvaluateDataFrameRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public DataframeEvaluation evaluation() {
        return this.evaluation;
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public Query query() {
        return this.query;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("evaluation");
        this.evaluation.serialize(generator, mapper);
        generator.writeKey("index");
        generator.write(this.index);
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
    }

    protected static void setupEvaluateDataFrameRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::evaluation, DataframeEvaluation._DESERIALIZER, "evaluation", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<EvaluateDataFrameRequest> {
        private DataframeEvaluation evaluation;
        private String index;
        @Nullable
        private Query query;

        public Builder evaluation(DataframeEvaluation value) {
            this.evaluation = value;
            return this;
        }

        public Builder evaluation(Function<DataframeEvaluation.Builder, ObjectBuilder<DataframeEvaluation>> fn) {
            return this.evaluation(fn.apply(new DataframeEvaluation.Builder()).build());
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        @Override
        public EvaluateDataFrameRequest build() {
            return new EvaluateDataFrameRequest(this);
        }
    }
}

