/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DetectionRule;
import co.elastic.clients.elasticsearch.ml.ExcludeFrequent;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Detector
implements JsonpSerializable {
    @Nullable
    private final String byFieldName;
    @Nullable
    private final List<DetectionRule> customRules;
    @Nullable
    private final String detectorDescription;
    @Nullable
    private final Integer detectorIndex;
    @Nullable
    private final ExcludeFrequent excludeFrequent;
    @Nullable
    private final String fieldName;
    private final String function;
    @Nullable
    private final String overFieldName;
    @Nullable
    private final String partitionFieldName;
    @Nullable
    private final Boolean useNull;
    public static final JsonpDeserializer<Detector> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Detector::setupDetectorDeserializer, Builder::build);

    public Detector(Builder builder) {
        this.byFieldName = builder.byFieldName;
        this.customRules = ModelTypeHelper.unmodifiable(builder.customRules);
        this.detectorDescription = builder.detectorDescription;
        this.detectorIndex = builder.detectorIndex;
        this.excludeFrequent = builder.excludeFrequent;
        this.fieldName = builder.fieldName;
        this.function = Objects.requireNonNull(builder.function, "function");
        this.overFieldName = builder.overFieldName;
        this.partitionFieldName = builder.partitionFieldName;
        this.useNull = builder.useNull;
    }

    public Detector(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String byFieldName() {
        return this.byFieldName;
    }

    @Nullable
    public List<DetectionRule> customRules() {
        return this.customRules;
    }

    @Nullable
    public String detectorDescription() {
        return this.detectorDescription;
    }

    @Nullable
    public Integer detectorIndex() {
        return this.detectorIndex;
    }

    @Nullable
    public ExcludeFrequent excludeFrequent() {
        return this.excludeFrequent;
    }

    @Nullable
    public String fieldName() {
        return this.fieldName;
    }

    public String function() {
        return this.function;
    }

    @Nullable
    public String overFieldName() {
        return this.overFieldName;
    }

    @Nullable
    public String partitionFieldName() {
        return this.partitionFieldName;
    }

    @Nullable
    public Boolean useNull() {
        return this.useNull;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.byFieldName != null) {
            generator.writeKey("by_field_name");
            generator.write(this.byFieldName);
        }
        if (this.customRules != null) {
            generator.writeKey("custom_rules");
            generator.writeStartArray();
            for (DetectionRule item0 : this.customRules) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.detectorDescription != null) {
            generator.writeKey("detector_description");
            generator.write(this.detectorDescription);
        }
        if (this.detectorIndex != null) {
            generator.writeKey("detector_index");
            generator.write(this.detectorIndex.intValue());
        }
        if (this.excludeFrequent != null) {
            generator.writeKey("exclude_frequent");
            this.excludeFrequent.serialize(generator, mapper);
        }
        if (this.fieldName != null) {
            generator.writeKey("field_name");
            generator.write(this.fieldName);
        }
        generator.writeKey("function");
        generator.write(this.function);
        if (this.overFieldName != null) {
            generator.writeKey("over_field_name");
            generator.write(this.overFieldName);
        }
        if (this.partitionFieldName != null) {
            generator.writeKey("partition_field_name");
            generator.write(this.partitionFieldName);
        }
        if (this.useNull != null) {
            generator.writeKey("use_null");
            generator.write(this.useNull.booleanValue());
        }
    }

    protected static void setupDetectorDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::byFieldName, JsonpDeserializer.stringDeserializer(), "by_field_name", new String[0]);
        op.add(Builder::customRules, JsonpDeserializer.arrayDeserializer(DetectionRule._DESERIALIZER), "custom_rules", new String[0]);
        op.add(Builder::detectorDescription, JsonpDeserializer.stringDeserializer(), "detector_description", new String[0]);
        op.add(Builder::detectorIndex, JsonpDeserializer.integerDeserializer(), "detector_index", new String[0]);
        op.add(Builder::excludeFrequent, ExcludeFrequent._DESERIALIZER, "exclude_frequent", new String[0]);
        op.add(Builder::fieldName, JsonpDeserializer.stringDeserializer(), "field_name", new String[0]);
        op.add(Builder::function, JsonpDeserializer.stringDeserializer(), "function", new String[0]);
        op.add(Builder::overFieldName, JsonpDeserializer.stringDeserializer(), "over_field_name", new String[0]);
        op.add(Builder::partitionFieldName, JsonpDeserializer.stringDeserializer(), "partition_field_name", new String[0]);
        op.add(Builder::useNull, JsonpDeserializer.booleanDeserializer(), "use_null", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Detector> {
        @Nullable
        private String byFieldName;
        @Nullable
        private List<DetectionRule> customRules;
        @Nullable
        private String detectorDescription;
        @Nullable
        private Integer detectorIndex;
        @Nullable
        private ExcludeFrequent excludeFrequent;
        @Nullable
        private String fieldName;
        private String function;
        @Nullable
        private String overFieldName;
        @Nullable
        private String partitionFieldName;
        @Nullable
        private Boolean useNull;

        public Builder byFieldName(@Nullable String value) {
            this.byFieldName = value;
            return this;
        }

        public Builder customRules(@Nullable List<DetectionRule> value) {
            this.customRules = value;
            return this;
        }

        public Builder customRules(DetectionRule ... value) {
            this.customRules = Arrays.asList(value);
            return this;
        }

        public Builder addCustomRules(DetectionRule value) {
            if (this.customRules == null) {
                this.customRules = new ArrayList<DetectionRule>();
            }
            this.customRules.add(value);
            return this;
        }

        public Builder customRules(Function<DetectionRule.Builder, ObjectBuilder<DetectionRule>> fn) {
            return this.customRules(fn.apply(new DetectionRule.Builder()).build());
        }

        public Builder addCustomRules(Function<DetectionRule.Builder, ObjectBuilder<DetectionRule>> fn) {
            return this.addCustomRules(fn.apply(new DetectionRule.Builder()).build());
        }

        public Builder detectorDescription(@Nullable String value) {
            this.detectorDescription = value;
            return this;
        }

        public Builder detectorIndex(@Nullable Integer value) {
            this.detectorIndex = value;
            return this;
        }

        public Builder excludeFrequent(@Nullable ExcludeFrequent value) {
            this.excludeFrequent = value;
            return this;
        }

        public Builder fieldName(@Nullable String value) {
            this.fieldName = value;
            return this;
        }

        public Builder function(String value) {
            this.function = value;
            return this;
        }

        public Builder overFieldName(@Nullable String value) {
            this.overFieldName = value;
            return this;
        }

        public Builder partitionFieldName(@Nullable String value) {
            this.partitionFieldName = value;
            return this;
        }

        public Builder useNull(@Nullable Boolean value) {
            this.useNull = value;
            return this;
        }

        @Override
        public Detector build() {
            return new Detector(this);
        }
    }
}

