/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.DeleteTrainedModelResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

public final class DeleteTrainedModelRequest
extends RequestBase {
    private final String modelId;
    public static final Endpoint<DeleteTrainedModelRequest, DeleteTrainedModelResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteTrainedModelRequest, DeleteTrainedModelResponse>(request -> "DELETE", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, DeleteTrainedModelResponse._DESERIALIZER);

    public DeleteTrainedModelRequest(Builder builder) {
        this.modelId = Objects.requireNonNull(builder.modelId, "model_id");
    }

    public DeleteTrainedModelRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String modelId() {
        return this.modelId;
    }

    public static class Builder
    implements ObjectBuilder<DeleteTrainedModelRequest> {
        private String modelId;

        public Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        @Override
        public DeleteTrainedModelRequest build() {
            return new DeleteTrainedModelRequest(this);
        }
    }
}

