/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license;

import co.elastic.clients.elasticsearch.license.LicenseType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class License
implements JsonpSerializable {
    private final String expiryDateInMillis;
    private final String issueDateInMillis;
    private final String issuedTo;
    private final String issuer;
    @Nullable
    private final Long maxNodes;
    @Nullable
    private final Long maxResourceUnits;
    private final String signature;
    private final String startDateInMillis;
    private final LicenseType type;
    private final String uid;
    public static final JsonpDeserializer<License> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, License::setupLicenseDeserializer, Builder::build);

    public License(Builder builder) {
        this.expiryDateInMillis = Objects.requireNonNull(builder.expiryDateInMillis, "expiry_date_in_millis");
        this.issueDateInMillis = Objects.requireNonNull(builder.issueDateInMillis, "issue_date_in_millis");
        this.issuedTo = Objects.requireNonNull(builder.issuedTo, "issued_to");
        this.issuer = Objects.requireNonNull(builder.issuer, "issuer");
        this.maxNodes = builder.maxNodes;
        this.maxResourceUnits = builder.maxResourceUnits;
        this.signature = Objects.requireNonNull(builder.signature, "signature");
        this.startDateInMillis = Objects.requireNonNull(builder.startDateInMillis, "start_date_in_millis");
        this.type = Objects.requireNonNull(builder.type, "type");
        this.uid = Objects.requireNonNull(builder.uid, "uid");
    }

    public License(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String expiryDateInMillis() {
        return this.expiryDateInMillis;
    }

    public String issueDateInMillis() {
        return this.issueDateInMillis;
    }

    public String issuedTo() {
        return this.issuedTo;
    }

    public String issuer() {
        return this.issuer;
    }

    @Nullable
    public Long maxNodes() {
        return this.maxNodes;
    }

    @Nullable
    public Long maxResourceUnits() {
        return this.maxResourceUnits;
    }

    public String signature() {
        return this.signature;
    }

    public String startDateInMillis() {
        return this.startDateInMillis;
    }

    public LicenseType type() {
        return this.type;
    }

    public String uid() {
        return this.uid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("expiry_date_in_millis");
        generator.write(this.expiryDateInMillis);
        generator.writeKey("issue_date_in_millis");
        generator.write(this.issueDateInMillis);
        generator.writeKey("issued_to");
        generator.write(this.issuedTo);
        generator.writeKey("issuer");
        generator.write(this.issuer);
        if (this.maxNodes != null) {
            generator.writeKey("max_nodes");
            generator.write(this.maxNodes.longValue());
        }
        if (this.maxResourceUnits != null) {
            generator.writeKey("max_resource_units");
            generator.write(this.maxResourceUnits.longValue());
        }
        generator.writeKey("signature");
        generator.write(this.signature);
        generator.writeKey("start_date_in_millis");
        generator.write(this.startDateInMillis);
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
        generator.writeKey("uid");
        generator.write(this.uid);
    }

    protected static void setupLicenseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::expiryDateInMillis, JsonpDeserializer.stringDeserializer(), "expiry_date_in_millis", new String[0]);
        op.add(Builder::issueDateInMillis, JsonpDeserializer.stringDeserializer(), "issue_date_in_millis", new String[0]);
        op.add(Builder::issuedTo, JsonpDeserializer.stringDeserializer(), "issued_to", new String[0]);
        op.add(Builder::issuer, JsonpDeserializer.stringDeserializer(), "issuer", new String[0]);
        op.add(Builder::maxNodes, JsonpDeserializer.longDeserializer(), "max_nodes", new String[0]);
        op.add(Builder::maxResourceUnits, JsonpDeserializer.longDeserializer(), "max_resource_units", new String[0]);
        op.add(Builder::signature, JsonpDeserializer.stringDeserializer(), "signature", new String[0]);
        op.add(Builder::startDateInMillis, JsonpDeserializer.stringDeserializer(), "start_date_in_millis", new String[0]);
        op.add(Builder::type, LicenseType._DESERIALIZER, "type", new String[0]);
        op.add(Builder::uid, JsonpDeserializer.stringDeserializer(), "uid", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<License> {
        private String expiryDateInMillis;
        private String issueDateInMillis;
        private String issuedTo;
        private String issuer;
        @Nullable
        private Long maxNodes;
        @Nullable
        private Long maxResourceUnits;
        private String signature;
        private String startDateInMillis;
        private LicenseType type;
        private String uid;

        public Builder expiryDateInMillis(String value) {
            this.expiryDateInMillis = value;
            return this;
        }

        public Builder issueDateInMillis(String value) {
            this.issueDateInMillis = value;
            return this;
        }

        public Builder issuedTo(String value) {
            this.issuedTo = value;
            return this;
        }

        public Builder issuer(String value) {
            this.issuer = value;
            return this;
        }

        public Builder maxNodes(@Nullable Long value) {
            this.maxNodes = value;
            return this;
        }

        public Builder maxResourceUnits(@Nullable Long value) {
            this.maxResourceUnits = value;
            return this;
        }

        public Builder signature(String value) {
            this.signature = value;
            return this;
        }

        public Builder startDateInMillis(String value) {
            this.startDateInMillis = value;
            return this;
        }

        public Builder type(LicenseType value) {
            this.type = value;
            return this;
        }

        public Builder uid(String value) {
            this.uid = value;
            return this;
        }

        @Override
        public License build() {
            return new License(this);
        }
    }
}

