/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.core.search.SortOrder;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class SortProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    private final SortOrder order;
    private final String targetField;
    public static final JsonpDeserializer<SortProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SortProcessor::setupSortProcessorDeserializer, Builder::build);

    public SortProcessor(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.order = Objects.requireNonNull(builder.order, "order");
        this.targetField = Objects.requireNonNull(builder.targetField, "target_field");
    }

    public SortProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "sort";
    }

    public String field() {
        return this.field;
    }

    public SortOrder order() {
        return this.order;
    }

    public String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("order");
        this.order.serialize(generator, mapper);
        generator.writeKey("target_field");
        generator.write(this.targetField);
    }

    protected static void setupSortProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::order, SortOrder._DESERIALIZER, "order", new String[0]);
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SortProcessor> {
        private String field;
        private SortOrder order;
        private String targetField;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder order(SortOrder value) {
            this.order = value;
            return this;
        }

        public Builder targetField(String value) {
            this.targetField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SortProcessor build() {
            return new SortProcessor(this);
        }
    }
}

