/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Pipeline
implements JsonpSerializable {
    @Nullable
    private final String description;
    @Nullable
    private final List<Processor> onFailure;
    @Nullable
    private final List<Processor> processors;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<Pipeline> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Pipeline::setupPipelineDeserializer, Builder::build);

    public Pipeline(Builder builder) {
        this.description = builder.description;
        this.onFailure = ModelTypeHelper.unmodifiable(builder.onFailure);
        this.processors = ModelTypeHelper.unmodifiable(builder.processors);
        this.version = builder.version;
    }

    public Pipeline(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String description() {
        return this.description;
    }

    @Nullable
    public List<Processor> onFailure() {
        return this.onFailure;
    }

    @Nullable
    public List<Processor> processors() {
        return this.processors;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.onFailure != null) {
            generator.writeKey("on_failure");
            generator.writeStartArray();
            for (Processor item0 : this.onFailure) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.processors != null) {
            generator.writeKey("processors");
            generator.writeStartArray();
            for (Processor item0 : this.processors) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
    }

    protected static void setupPipelineDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::onFailure, JsonpDeserializer.arrayDeserializer(Processor._DESERIALIZER), "on_failure", new String[0]);
        op.add(Builder::processors, JsonpDeserializer.arrayDeserializer(Processor._DESERIALIZER), "processors", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Pipeline> {
        @Nullable
        private String description;
        @Nullable
        private List<Processor> onFailure;
        @Nullable
        private List<Processor> processors;
        @Nullable
        private Long version;

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder onFailure(@Nullable List<Processor> value) {
            this.onFailure = value;
            return this;
        }

        public Builder onFailure(Processor ... value) {
            this.onFailure = Arrays.asList(value);
            return this;
        }

        public Builder addOnFailure(Processor value) {
            if (this.onFailure == null) {
                this.onFailure = new ArrayList<Processor>();
            }
            this.onFailure.add(value);
            return this;
        }

        public Builder onFailure(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.onFailure(fn.apply(new Processor.Builder()).build());
        }

        public Builder addOnFailure(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.addOnFailure(fn.apply(new Processor.Builder()).build());
        }

        public Builder processors(@Nullable List<Processor> value) {
            this.processors = value;
            return this;
        }

        public Builder processors(Processor ... value) {
            this.processors = Arrays.asList(value);
            return this;
        }

        public Builder addProcessors(Processor value) {
            if (this.processors == null) {
                this.processors = new ArrayList<Processor>();
            }
            this.processors.add(value);
            return this;
        }

        public Builder processors(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.processors(fn.apply(new Processor.Builder()).build());
        }

        public Builder addProcessors(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.addProcessors(fn.apply(new Processor.Builder()).build());
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        public Pipeline build() {
            return new Pipeline(this);
        }
    }
}

