/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ShardsTotalStats
implements JsonpSerializable {
    private final long totalCount;
    public static final JsonpDeserializer<ShardsTotalStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardsTotalStats::setupShardsTotalStatsDeserializer, Builder::build);

    public ShardsTotalStats(Builder builder) {
        this.totalCount = Objects.requireNonNull(builder.totalCount, "total_count");
    }

    public ShardsTotalStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long totalCount() {
        return this.totalCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total_count");
        generator.write(this.totalCount);
    }

    protected static void setupShardsTotalStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::totalCount, JsonpDeserializer.longDeserializer(), "total_count", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardsTotalStats> {
        private Long totalCount;

        public Builder totalCount(long value) {
            this.totalCount = value;
            return this;
        }

        @Override
        public ShardsTotalStats build() {
            return new ShardsTotalStats(this);
        }
    }
}

