/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ShardCommit
implements JsonpSerializable {
    private final int generation;
    private final String id;
    private final long numDocs;
    private final Map<String, String> userData;
    public static final JsonpDeserializer<ShardCommit> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardCommit::setupShardCommitDeserializer, Builder::build);

    public ShardCommit(Builder builder) {
        this.generation = Objects.requireNonNull(builder.generation, "generation");
        this.id = Objects.requireNonNull(builder.id, "id");
        this.numDocs = Objects.requireNonNull(builder.numDocs, "num_docs");
        this.userData = ModelTypeHelper.unmodifiableNonNull(builder.userData, "user_data");
    }

    public ShardCommit(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int generation() {
        return this.generation;
    }

    public String id() {
        return this.id;
    }

    public long numDocs() {
        return this.numDocs;
    }

    public Map<String, String> userData() {
        return this.userData;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("generation");
        generator.write(this.generation);
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("num_docs");
        generator.write(this.numDocs);
        generator.writeKey("user_data");
        generator.writeStartObject();
        for (Map.Entry<String, String> item0 : this.userData.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.write(item0.getValue());
        }
        generator.writeEnd();
    }

    protected static void setupShardCommitDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::generation, JsonpDeserializer.integerDeserializer(), "generation", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::numDocs, JsonpDeserializer.longDeserializer(), "num_docs", new String[0]);
        op.add(Builder::userData, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "user_data", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardCommit> {
        private Integer generation;
        private String id;
        private Long numDocs;
        private Map<String, String> userData;

        public Builder generation(int value) {
            this.generation = value;
            return this;
        }

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder numDocs(long value) {
            this.numDocs = value;
            return this;
        }

        public Builder userData(Map<String, String> value) {
            this.userData = value;
            return this;
        }

        public Builder putUserData(String key, String value) {
            if (this.userData == null) {
                this.userData = new HashMap<String, String>();
            }
            this.userData.put(key, value);
            return this;
        }

        @Override
        public ShardCommit build() {
            return new ShardCommit(this);
        }
    }
}

