/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.IndexRoutingAllocationDisk;
import co.elastic.clients.elasticsearch.indices.IndexRoutingAllocationInclude;
import co.elastic.clients.elasticsearch.indices.IndexRoutingAllocationInitialRecovery;
import co.elastic.clients.elasticsearch.indices.IndexRoutingAllocationOptions;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IndexRoutingAllocation
implements JsonpSerializable {
    @Nullable
    private final IndexRoutingAllocationOptions enable;
    @Nullable
    private final IndexRoutingAllocationInclude include;
    @Nullable
    private final IndexRoutingAllocationInitialRecovery initialRecovery;
    @Nullable
    private final IndexRoutingAllocationDisk disk;
    public static final JsonpDeserializer<IndexRoutingAllocation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexRoutingAllocation::setupIndexRoutingAllocationDeserializer, Builder::build);

    public IndexRoutingAllocation(Builder builder) {
        this.enable = builder.enable;
        this.include = builder.include;
        this.initialRecovery = builder.initialRecovery;
        this.disk = builder.disk;
    }

    public IndexRoutingAllocation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public IndexRoutingAllocationOptions enable() {
        return this.enable;
    }

    @Nullable
    public IndexRoutingAllocationInclude include() {
        return this.include;
    }

    @Nullable
    public IndexRoutingAllocationInitialRecovery initialRecovery() {
        return this.initialRecovery;
    }

    @Nullable
    public IndexRoutingAllocationDisk disk() {
        return this.disk;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.enable != null) {
            generator.writeKey("enable");
            this.enable.serialize(generator, mapper);
        }
        if (this.include != null) {
            generator.writeKey("include");
            this.include.serialize(generator, mapper);
        }
        if (this.initialRecovery != null) {
            generator.writeKey("initial_recovery");
            this.initialRecovery.serialize(generator, mapper);
        }
        if (this.disk != null) {
            generator.writeKey("disk");
            this.disk.serialize(generator, mapper);
        }
    }

    protected static void setupIndexRoutingAllocationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::enable, IndexRoutingAllocationOptions._DESERIALIZER, "enable", new String[0]);
        op.add(Builder::include, IndexRoutingAllocationInclude._DESERIALIZER, "include", new String[0]);
        op.add(Builder::initialRecovery, IndexRoutingAllocationInitialRecovery._DESERIALIZER, "initial_recovery", new String[0]);
        op.add(Builder::disk, IndexRoutingAllocationDisk._DESERIALIZER, "disk", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndexRoutingAllocation> {
        @Nullable
        private IndexRoutingAllocationOptions enable;
        @Nullable
        private IndexRoutingAllocationInclude include;
        @Nullable
        private IndexRoutingAllocationInitialRecovery initialRecovery;
        @Nullable
        private IndexRoutingAllocationDisk disk;

        public Builder enable(@Nullable IndexRoutingAllocationOptions value) {
            this.enable = value;
            return this;
        }

        public Builder include(@Nullable IndexRoutingAllocationInclude value) {
            this.include = value;
            return this;
        }

        public Builder include(Function<IndexRoutingAllocationInclude.Builder, ObjectBuilder<IndexRoutingAllocationInclude>> fn) {
            return this.include(fn.apply(new IndexRoutingAllocationInclude.Builder()).build());
        }

        public Builder initialRecovery(@Nullable IndexRoutingAllocationInitialRecovery value) {
            this.initialRecovery = value;
            return this;
        }

        public Builder initialRecovery(Function<IndexRoutingAllocationInitialRecovery.Builder, ObjectBuilder<IndexRoutingAllocationInitialRecovery>> fn) {
            return this.initialRecovery(fn.apply(new IndexRoutingAllocationInitialRecovery.Builder()).build());
        }

        public Builder disk(@Nullable IndexRoutingAllocationDisk value) {
            this.disk = value;
            return this;
        }

        public Builder disk(Function<IndexRoutingAllocationDisk.Builder, ObjectBuilder<IndexRoutingAllocationDisk>> fn) {
            return this.disk(fn.apply(new IndexRoutingAllocationDisk.Builder()).build());
        }

        @Override
        public IndexRoutingAllocation build() {
            return new IndexRoutingAllocation(this);
        }
    }
}

