/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.get_data_stream.IndicesGetDataStreamItem;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class GetDataStreamResponse
implements JsonpSerializable {
    private final List<IndicesGetDataStreamItem> dataStreams;
    public static final JsonpDeserializer<GetDataStreamResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetDataStreamResponse::setupGetDataStreamResponseDeserializer, Builder::build);

    public GetDataStreamResponse(Builder builder) {
        this.dataStreams = ModelTypeHelper.unmodifiableNonNull(builder.dataStreams, "data_streams");
    }

    public GetDataStreamResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<IndicesGetDataStreamItem> dataStreams() {
        return this.dataStreams;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("data_streams");
        generator.writeStartArray();
        for (IndicesGetDataStreamItem item0 : this.dataStreams) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetDataStreamResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::dataStreams, JsonpDeserializer.arrayDeserializer(IndicesGetDataStreamItem._DESERIALIZER), "data_streams", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetDataStreamResponse> {
        private List<IndicesGetDataStreamItem> dataStreams;

        public Builder dataStreams(List<IndicesGetDataStreamItem> value) {
            this.dataStreams = value;
            return this;
        }

        public Builder dataStreams(IndicesGetDataStreamItem ... value) {
            this.dataStreams = Arrays.asList(value);
            return this;
        }

        public Builder addDataStreams(IndicesGetDataStreamItem value) {
            if (this.dataStreams == null) {
                this.dataStreams = new ArrayList<IndicesGetDataStreamItem>();
            }
            this.dataStreams.add(value);
            return this;
        }

        public Builder dataStreams(Function<IndicesGetDataStreamItem.Builder, ObjectBuilder<IndicesGetDataStreamItem>> fn) {
            return this.dataStreams(fn.apply(new IndicesGetDataStreamItem.Builder()).build());
        }

        public Builder addDataStreams(Function<IndicesGetDataStreamItem.Builder, ObjectBuilder<IndicesGetDataStreamItem>> fn) {
            return this.addDataStreams(fn.apply(new IndicesGetDataStreamItem.Builder()).build());
        }

        @Override
        public GetDataStreamResponse build() {
            return new GetDataStreamResponse(this);
        }
    }
}

