/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.BooleanEndpoint;
import co.elastic.clients.base.BooleanResponse;
import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class ExistsTemplateRequest
extends RequestBase {
    private final List<String> name;
    @Nullable
    private final Boolean flatSettings;
    @Nullable
    private final Boolean local;
    @Nullable
    private final String masterTimeout;
    public static final Endpoint<ExistsTemplateRequest, BooleanResponse, ElasticsearchError> ENDPOINT = new BooleanEndpoint<ExistsTemplateRequest>(request -> "HEAD", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_template");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, (Function<ExistsTemplateRequest, Map<String, String>>)((Function<ExistsTemplateRequest, Map>)request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.flatSettings != null) {
            params.put("flat_settings", String.valueOf(request.flatSettings));
        }
        if (request.local != null) {
            params.put("local", String.valueOf(request.local));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        return params;
    }), (Function<ExistsTemplateRequest, Map<String, String>>)SimpleEndpoint.emptyMap(), false, null);

    public ExistsTemplateRequest(Builder builder) {
        this.name = ModelTypeHelper.unmodifiableNonNull(builder.name, "name");
        this.flatSettings = builder.flatSettings;
        this.local = builder.local;
        this.masterTimeout = builder.masterTimeout;
    }

    public ExistsTemplateRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> name() {
        return this.name;
    }

    @Nullable
    public Boolean flatSettings() {
        return this.flatSettings;
    }

    @Nullable
    public Boolean local() {
        return this.local;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    public static class Builder
    implements ObjectBuilder<ExistsTemplateRequest> {
        private List<String> name;
        @Nullable
        private Boolean flatSettings;
        @Nullable
        private Boolean local;
        @Nullable
        private String masterTimeout;

        public Builder name(List<String> value) {
            this.name = value;
            return this;
        }

        public Builder name(String ... value) {
            this.name = Arrays.asList(value);
            return this;
        }

        public Builder addName(String value) {
            if (this.name == null) {
                this.name = new ArrayList<String>();
            }
            this.name.add(value);
            return this;
        }

        public Builder flatSettings(@Nullable Boolean value) {
            this.flatSettings = value;
            return this;
        }

        public Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        @Override
        public ExistsTemplateRequest build() {
            return new ExistsTemplateRequest(this);
        }
    }
}

