/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.Alias;
import co.elastic.clients.elasticsearch.indices.CreateIndexResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CreateIndexRequest
extends RequestBase
implements JsonpSerializable {
    private final String index;
    @Nullable
    private final Boolean includeTypeName;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    @Nullable
    private final JsonValue waitForActiveShards;
    @Nullable
    private final Map<String, Alias> aliases;
    @Nullable
    private final JsonValue mappings;
    @Nullable
    private final Map<String, JsonData> settings;
    public static final JsonpDeserializer<CreateIndexRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateIndexRequest::setupCreateIndexRequestDeserializer, Builder::build);
    public static final Endpoint<CreateIndexRequest, CreateIndexResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<CreateIndexRequest, CreateIndexResponse>(request -> "PUT", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.includeTypeName != null) {
            params.put("include_type_name", String.valueOf(request.includeTypeName));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", JsonpUtils.toString(request.waitForActiveShards));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, CreateIndexResponse._DESERIALIZER);

    public CreateIndexRequest(Builder builder) {
        this.index = Objects.requireNonNull(builder.index, "index");
        this.includeTypeName = builder.includeTypeName;
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
        this.waitForActiveShards = builder.waitForActiveShards;
        this.aliases = ModelTypeHelper.unmodifiable(builder.aliases);
        this.mappings = builder.mappings;
        this.settings = ModelTypeHelper.unmodifiable(builder.settings);
    }

    public CreateIndexRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public Boolean includeTypeName() {
        return this.includeTypeName;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public JsonValue waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Nullable
    public Map<String, Alias> aliases() {
        return this.aliases;
    }

    @Nullable
    public JsonValue mappings() {
        return this.mappings;
    }

    @Nullable
    public Map<String, JsonData> settings() {
        return this.settings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.aliases != null) {
            generator.writeKey("aliases");
            generator.writeStartObject();
            for (Map.Entry<String, Alias> entry : this.aliases.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.mappings != null) {
            generator.writeKey("mappings");
            generator.write(this.mappings);
        }
        if (this.settings != null) {
            generator.writeKey("settings");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.settings.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupCreateIndexRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aliases, JsonpDeserializer.stringMapDeserializer(Alias._DESERIALIZER), "aliases", new String[0]);
        op.add(Builder::mappings, JsonpDeserializer.jsonValueDeserializer(), "mappings", new String[0]);
        op.add(Builder::settings, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "settings", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CreateIndexRequest> {
        private String index;
        @Nullable
        private Boolean includeTypeName;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;
        @Nullable
        private JsonValue waitForActiveShards;
        @Nullable
        private Map<String, Alias> aliases;
        @Nullable
        private JsonValue mappings;
        @Nullable
        private Map<String, JsonData> settings;

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder includeTypeName(@Nullable Boolean value) {
            this.includeTypeName = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder waitForActiveShards(@Nullable JsonValue value) {
            this.waitForActiveShards = value;
            return this;
        }

        public Builder aliases(@Nullable Map<String, Alias> value) {
            this.aliases = value;
            return this;
        }

        public Builder putAliases(String key, Alias value) {
            if (this.aliases == null) {
                this.aliases = new HashMap<String, Alias>();
            }
            this.aliases.put(key, value);
            return this;
        }

        public Builder aliases(String key, Function<Alias.Builder, ObjectBuilder<Alias>> fn) {
            return this.aliases(Collections.singletonMap(key, fn.apply(new Alias.Builder()).build()));
        }

        public Builder putAliases(String key, Function<Alias.Builder, ObjectBuilder<Alias>> fn) {
            return this.putAliases(key, fn.apply(new Alias.Builder()).build());
        }

        public Builder mappings(@Nullable JsonValue value) {
            this.mappings = value;
            return this;
        }

        public Builder settings(@Nullable Map<String, JsonData> value) {
            this.settings = value;
            return this;
        }

        public Builder putSettings(String key, JsonData value) {
            if (this.settings == null) {
                this.settings = new HashMap<String, JsonData>();
            }
            this.settings.put(key, value);
            return this;
        }

        @Override
        public CreateIndexRequest build() {
            return new CreateIndexRequest(this);
        }
    }
}

