/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AliasDefinition
implements JsonpSerializable {
    @Nullable
    private final Query filter;
    @Nullable
    private final String indexRouting;
    @Nullable
    private final Boolean isWriteIndex;
    @Nullable
    private final String routing;
    @Nullable
    private final String searchRouting;
    public static final JsonpDeserializer<AliasDefinition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AliasDefinition::setupAliasDefinitionDeserializer, Builder::build);

    public AliasDefinition(Builder builder) {
        this.filter = builder.filter;
        this.indexRouting = builder.indexRouting;
        this.isWriteIndex = builder.isWriteIndex;
        this.routing = builder.routing;
        this.searchRouting = builder.searchRouting;
    }

    public AliasDefinition(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Query filter() {
        return this.filter;
    }

    @Nullable
    public String indexRouting() {
        return this.indexRouting;
    }

    @Nullable
    public Boolean isWriteIndex() {
        return this.isWriteIndex;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public String searchRouting() {
        return this.searchRouting;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.indexRouting != null) {
            generator.writeKey("index_routing");
            generator.write(this.indexRouting);
        }
        if (this.isWriteIndex != null) {
            generator.writeKey("is_write_index");
            generator.write(this.isWriteIndex.booleanValue());
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (this.searchRouting != null) {
            generator.writeKey("search_routing");
            generator.write(this.searchRouting);
        }
    }

    protected static void setupAliasDefinitionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::filter, Query._DESERIALIZER, "filter", new String[0]);
        op.add(Builder::indexRouting, JsonpDeserializer.stringDeserializer(), "index_routing", new String[0]);
        op.add(Builder::isWriteIndex, JsonpDeserializer.booleanDeserializer(), "is_write_index", new String[0]);
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing", new String[0]);
        op.add(Builder::searchRouting, JsonpDeserializer.stringDeserializer(), "search_routing", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AliasDefinition> {
        @Nullable
        private Query filter;
        @Nullable
        private String indexRouting;
        @Nullable
        private Boolean isWriteIndex;
        @Nullable
        private String routing;
        @Nullable
        private String searchRouting;

        public Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public Builder indexRouting(@Nullable String value) {
            this.indexRouting = value;
            return this;
        }

        public Builder isWriteIndex(@Nullable Boolean value) {
            this.isWriteIndex = value;
            return this;
        }

        public Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder searchRouting(@Nullable String value) {
            this.searchRouting = value;
            return this;
        }

        @Override
        public AliasDefinition build() {
            return new AliasDefinition(this);
        }
    }
}

