/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.elasticsearch.ilm.explain_lifecycle.LifecycleExplain;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class ExplainLifecycleResponse
implements JsonpSerializable {
    private final Map<String, LifecycleExplain> indices;
    public static final JsonpDeserializer<ExplainLifecycleResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExplainLifecycleResponse::setupExplainLifecycleResponseDeserializer, Builder::build);

    public ExplainLifecycleResponse(Builder builder) {
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
    }

    public ExplainLifecycleResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, LifecycleExplain> indices() {
        return this.indices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("indices");
        generator.writeStartObject();
        for (Map.Entry<String, LifecycleExplain> item0 : this.indices.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupExplainLifecycleResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(LifecycleExplain._DESERIALIZER), "indices", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ExplainLifecycleResponse> {
        private Map<String, LifecycleExplain> indices;

        public Builder indices(Map<String, LifecycleExplain> value) {
            this.indices = value;
            return this;
        }

        public Builder putIndices(String key, LifecycleExplain value) {
            if (this.indices == null) {
                this.indices = new HashMap<String, LifecycleExplain>();
            }
            this.indices.put(key, value);
            return this;
        }

        public Builder indices(String key, Function<LifecycleExplain.Builder, ObjectBuilder<LifecycleExplain>> fn) {
            return this.indices(Collections.singletonMap(key, fn.apply(new LifecycleExplain.Builder()).build()));
        }

        public Builder putIndices(String key, Function<LifecycleExplain.Builder, ObjectBuilder<LifecycleExplain>> fn) {
            return this.putIndices(key, fn.apply(new LifecycleExplain.Builder()).build());
        }

        @Override
        public ExplainLifecycleResponse build() {
            return new ExplainLifecycleResponse(this);
        }
    }
}

