/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.eql;

import co.elastic.clients.elasticsearch.eql.HitsEvent;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class HitsSequence<TEvent>
implements JsonpSerializable {
    private final List<HitsEvent<TEvent>> events;
    private final List<JsonData> joinKeys;
    @Nullable
    private final JsonpSerializer<TEvent> tEventSerializer;

    public HitsSequence(Builder<TEvent> builder) {
        this.events = ModelTypeHelper.unmodifiableNonNull(((Builder)builder).events, "events");
        this.joinKeys = ModelTypeHelper.unmodifiableNonNull(((Builder)builder).joinKeys, "join_keys");
        this.tEventSerializer = ((Builder)builder).tEventSerializer;
    }

    public HitsSequence(Function<Builder<TEvent>, Builder<TEvent>> fn) {
        this(fn.apply(new Builder()));
    }

    public List<HitsEvent<TEvent>> events() {
        return this.events;
    }

    public List<JsonData> joinKeys() {
        return this.joinKeys;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("events");
        generator.writeStartArray();
        for (HitsEvent<TEvent> hitsEvent : this.events) {
            hitsEvent.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("join_keys");
        generator.writeStartArray();
        for (JsonData jsonData : this.joinKeys) {
            jsonData.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public static <TEvent> JsonpDeserializer<HitsSequence<TEvent>> createHitsSequenceDeserializer(JsonpDeserializer<TEvent> tEventDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> HitsSequence.setupHitsSequenceDeserializer(op, tEventDeserializer));
    }

    protected static <TEvent> void setupHitsSequenceDeserializer(DelegatingDeserializer<Builder<TEvent>> op, JsonpDeserializer<TEvent> tEventDeserializer) {
        op.add(Builder::events, JsonpDeserializer.arrayDeserializer(HitsEvent.createHitsEventDeserializer(tEventDeserializer)), "events", new String[0]);
        op.add(Builder::joinKeys, JsonpDeserializer.arrayDeserializer(JsonData._DESERIALIZER), "join_keys", new String[0]);
    }

    public static class Builder<TEvent>
    implements ObjectBuilder<HitsSequence<TEvent>> {
        private List<HitsEvent<TEvent>> events;
        private List<JsonData> joinKeys;
        @Nullable
        private JsonpSerializer<TEvent> tEventSerializer;

        public Builder<TEvent> events(List<HitsEvent<TEvent>> value) {
            this.events = value;
            return this;
        }

        public Builder<TEvent> events(HitsEvent<TEvent> ... value) {
            this.events = Arrays.asList(value);
            return this;
        }

        public Builder<TEvent> addEvents(HitsEvent<TEvent> value) {
            if (this.events == null) {
                this.events = new ArrayList<HitsEvent<TEvent>>();
            }
            this.events.add(value);
            return this;
        }

        public Builder<TEvent> events(Function<HitsEvent.Builder<TEvent>, ObjectBuilder<HitsEvent<TEvent>>> fn) {
            return this.events(fn.apply(new HitsEvent.Builder()).build());
        }

        public Builder<TEvent> addEvents(Function<HitsEvent.Builder<TEvent>, ObjectBuilder<HitsEvent<TEvent>>> fn) {
            return this.addEvents(fn.apply(new HitsEvent.Builder()).build());
        }

        public Builder<TEvent> joinKeys(List<JsonData> value) {
            this.joinKeys = value;
            return this;
        }

        public Builder<TEvent> joinKeys(JsonData ... value) {
            this.joinKeys = Arrays.asList(value);
            return this;
        }

        public Builder<TEvent> addJoinKeys(JsonData value) {
            if (this.joinKeys == null) {
                this.joinKeys = new ArrayList<JsonData>();
            }
            this.joinKeys.add(value);
            return this;
        }

        public Builder<TEvent> tEventSerializer(@Nullable JsonpSerializer<TEvent> value) {
            this.tEventSerializer = value;
            return this;
        }

        @Override
        public HitsSequence<TEvent> build() {
            return new HitsSequence(this);
        }
    }
}

