/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.eql;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.eql.EqlSearchResponse;
import co.elastic.clients.elasticsearch.eql.search.ResultPosition;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class EqlSearchRequest
extends RequestBase
implements JsonpSerializable {
    private final String index;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final Boolean ignoreUnavailable;
    private final String query;
    @Nullable
    private final Boolean caseSensitive;
    @Nullable
    private final String eventCategoryField;
    @Nullable
    private final String tiebreakerField;
    @Nullable
    private final String timestampField;
    @Nullable
    private final Number fetchSize;
    @Nullable
    private final List<Query> filter;
    @Nullable
    private final String keepAlive;
    @Nullable
    private final Boolean keepOnCompletion;
    @Nullable
    private final String waitForCompletionTimeout;
    @Nullable
    private final JsonValue size;
    @Nullable
    private final List<JsonValue> fields;
    @Nullable
    private final ResultPosition resultPosition;
    public static final JsonpDeserializer<EqlSearchRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EqlSearchRequest::setupEqlSearchRequestDeserializer, Builder::build);
    private static final SimpleEndpoint<EqlSearchRequest, Void> ENDPOINT = new SimpleEndpoint(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_eql");
            buf.append("/search");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, null);

    public EqlSearchRequest(Builder builder) {
        this.index = Objects.requireNonNull(builder.index, "index");
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.query = Objects.requireNonNull(builder.query, "query");
        this.caseSensitive = builder.caseSensitive;
        this.eventCategoryField = builder.eventCategoryField;
        this.tiebreakerField = builder.tiebreakerField;
        this.timestampField = builder.timestampField;
        this.fetchSize = builder.fetchSize;
        this.filter = ModelTypeHelper.unmodifiable(builder.filter);
        this.keepAlive = builder.keepAlive;
        this.keepOnCompletion = builder.keepOnCompletion;
        this.waitForCompletionTimeout = builder.waitForCompletionTimeout;
        this.size = builder.size;
        this.fields = ModelTypeHelper.unmodifiable(builder.fields);
        this.resultPosition = builder.resultPosition;
    }

    public EqlSearchRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public String query() {
        return this.query;
    }

    @Nullable
    public Boolean caseSensitive() {
        return this.caseSensitive;
    }

    @Nullable
    public String eventCategoryField() {
        return this.eventCategoryField;
    }

    @Nullable
    public String tiebreakerField() {
        return this.tiebreakerField;
    }

    @Nullable
    public String timestampField() {
        return this.timestampField;
    }

    @Nullable
    public Number fetchSize() {
        return this.fetchSize;
    }

    @Nullable
    public List<Query> filter() {
        return this.filter;
    }

    @Nullable
    public String keepAlive() {
        return this.keepAlive;
    }

    @Nullable
    public Boolean keepOnCompletion() {
        return this.keepOnCompletion;
    }

    @Nullable
    public String waitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    @Nullable
    public JsonValue size() {
        return this.size;
    }

    @Nullable
    public List<JsonValue> fields() {
        return this.fields;
    }

    @Nullable
    public ResultPosition resultPosition() {
        return this.resultPosition;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("query");
        generator.write(this.query);
        if (this.caseSensitive != null) {
            generator.writeKey("case_sensitive");
            generator.write(this.caseSensitive.booleanValue());
        }
        if (this.eventCategoryField != null) {
            generator.writeKey("event_category_field");
            generator.write(this.eventCategoryField);
        }
        if (this.tiebreakerField != null) {
            generator.writeKey("tiebreaker_field");
            generator.write(this.tiebreakerField);
        }
        if (this.timestampField != null) {
            generator.writeKey("timestamp_field");
            generator.write(this.timestampField);
        }
        if (this.fetchSize != null) {
            generator.writeKey("fetch_size");
            generator.write(this.fetchSize.doubleValue());
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (Query query : this.filter) {
                query.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.keepAlive != null) {
            generator.writeKey("keep_alive");
            generator.write(this.keepAlive);
        }
        if (this.keepOnCompletion != null) {
            generator.writeKey("keep_on_completion");
            generator.write(this.keepOnCompletion.booleanValue());
        }
        if (this.waitForCompletionTimeout != null) {
            generator.writeKey("wait_for_completion_timeout");
            generator.write(this.waitForCompletionTimeout);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (JsonValue jsonValue : this.fields) {
                generator.write(jsonValue);
            }
            generator.writeEnd();
        }
        if (this.resultPosition != null) {
            generator.writeKey("result_position");
            this.resultPosition.serialize(generator, mapper);
        }
    }

    protected static void setupEqlSearchRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query", new String[0]);
        op.add(Builder::caseSensitive, JsonpDeserializer.booleanDeserializer(), "case_sensitive", new String[0]);
        op.add(Builder::eventCategoryField, JsonpDeserializer.stringDeserializer(), "event_category_field", new String[0]);
        op.add(Builder::tiebreakerField, JsonpDeserializer.stringDeserializer(), "tiebreaker_field", new String[0]);
        op.add(Builder::timestampField, JsonpDeserializer.stringDeserializer(), "timestamp_field", new String[0]);
        op.add(Builder::fetchSize, JsonpDeserializer.numberDeserializer(), "fetch_size", new String[0]);
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "filter", new String[0]);
        op.add(Builder::keepAlive, JsonpDeserializer.stringDeserializer(), "keep_alive", new String[0]);
        op.add(Builder::keepOnCompletion, JsonpDeserializer.booleanDeserializer(), "keep_on_completion", new String[0]);
        op.add(Builder::waitForCompletionTimeout, JsonpDeserializer.stringDeserializer(), "wait_for_completion_timeout", new String[0]);
        op.add(Builder::size, JsonpDeserializer.jsonValueDeserializer(), "size", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "fields", new String[0]);
        op.add(Builder::resultPosition, ResultPosition._DESERIALIZER, "result_position", new String[0]);
    }

    public static <TEvent> Endpoint<EqlSearchRequest, EqlSearchResponse<TEvent>, ElasticsearchError> createSearchEndpoint(JsonpDeserializer<TEvent> tEventDeserializer) {
        return ENDPOINT.withResponseDeserializer(EqlSearchResponse.createEqlSearchResponseDeserializer(tEventDeserializer));
    }

    public static class Builder
    implements ObjectBuilder<EqlSearchRequest> {
        private String index;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private Boolean ignoreUnavailable;
        private String query;
        @Nullable
        private Boolean caseSensitive;
        @Nullable
        private String eventCategoryField;
        @Nullable
        private String tiebreakerField;
        @Nullable
        private String timestampField;
        @Nullable
        private Number fetchSize;
        @Nullable
        private List<Query> filter;
        @Nullable
        private String keepAlive;
        @Nullable
        private Boolean keepOnCompletion;
        @Nullable
        private String waitForCompletionTimeout;
        @Nullable
        private JsonValue size;
        @Nullable
        private List<JsonValue> fields;
        @Nullable
        private ResultPosition resultPosition;

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder query(String value) {
            this.query = value;
            return this;
        }

        public Builder caseSensitive(@Nullable Boolean value) {
            this.caseSensitive = value;
            return this;
        }

        public Builder eventCategoryField(@Nullable String value) {
            this.eventCategoryField = value;
            return this;
        }

        public Builder tiebreakerField(@Nullable String value) {
            this.tiebreakerField = value;
            return this;
        }

        public Builder timestampField(@Nullable String value) {
            this.timestampField = value;
            return this;
        }

        public Builder fetchSize(@Nullable Number value) {
            this.fetchSize = value;
            return this;
        }

        public Builder filter(@Nullable List<Query> value) {
            this.filter = value;
            return this;
        }

        public Builder filter(Query ... value) {
            this.filter = Arrays.asList(value);
            return this;
        }

        public Builder addFilter(Query value) {
            if (this.filter == null) {
                this.filter = new ArrayList<Query>();
            }
            this.filter.add(value);
            return this;
        }

        public Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public Builder addFilter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.addFilter(fn.apply(new Query.Builder()).build());
        }

        public Builder keepAlive(@Nullable String value) {
            this.keepAlive = value;
            return this;
        }

        public Builder keepOnCompletion(@Nullable Boolean value) {
            this.keepOnCompletion = value;
            return this;
        }

        public Builder waitForCompletionTimeout(@Nullable String value) {
            this.waitForCompletionTimeout = value;
            return this;
        }

        public Builder size(@Nullable JsonValue value) {
            this.size = value;
            return this;
        }

        public Builder fields(@Nullable List<JsonValue> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(JsonValue ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(JsonValue value) {
            if (this.fields == null) {
                this.fields = new ArrayList<JsonValue>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder resultPosition(@Nullable ResultPosition value) {
            this.resultPosition = value;
            return this;
        }

        @Override
        public EqlSearchRequest build() {
            return new EqlSearchRequest(this);
        }
    }
}

