/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.eql;

import co.elastic.clients.base.ApiClient;
import co.elastic.clients.base.Transport;
import co.elastic.clients.elasticsearch.eql.EqlDeleteRequest;
import co.elastic.clients.elasticsearch.eql.EqlDeleteResponse;
import co.elastic.clients.elasticsearch.eql.EqlGetRequest;
import co.elastic.clients.elasticsearch.eql.EqlGetResponse;
import co.elastic.clients.elasticsearch.eql.EqlSearchRequest;
import co.elastic.clients.elasticsearch.eql.EqlSearchResponse;
import co.elastic.clients.elasticsearch.eql.GetStatusRequest;
import co.elastic.clients.elasticsearch.eql.GetStatusResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class ElasticsearchEqlAsyncClient
extends ApiClient {
    public ElasticsearchEqlAsyncClient(Transport transport) {
        super(transport);
    }

    public CompletableFuture<EqlDeleteResponse> delete(EqlDeleteRequest request) throws IOException {
        return this.transport.performRequestAsync(request, EqlDeleteRequest.ENDPOINT);
    }

    public final CompletableFuture<EqlDeleteResponse> delete(Function<EqlDeleteRequest.Builder, ObjectBuilder<EqlDeleteRequest>> fn) throws IOException {
        return this.delete(fn.apply(new EqlDeleteRequest.Builder()).build());
    }

    public <TEvent> CompletableFuture<EqlGetResponse<TEvent>> get(EqlGetRequest request, Class<TEvent> tEventClass) throws IOException {
        return this.transport.performRequestAsync(request, EqlGetRequest.createGetEndpoint(this.getDeserializer(tEventClass)));
    }

    public final <TEvent> CompletableFuture<EqlGetResponse<TEvent>> get(Function<EqlGetRequest.Builder, ObjectBuilder<EqlGetRequest>> fn, Class<TEvent> tEventClass) throws IOException {
        return this.get(fn.apply(new EqlGetRequest.Builder()).build(), tEventClass);
    }

    public CompletableFuture<GetStatusResponse> getStatus(GetStatusRequest request) throws IOException {
        return this.transport.performRequestAsync(request, GetStatusRequest.ENDPOINT);
    }

    public final CompletableFuture<GetStatusResponse> getStatus(Function<GetStatusRequest.Builder, ObjectBuilder<GetStatusRequest>> fn) throws IOException {
        return this.getStatus(fn.apply(new GetStatusRequest.Builder()).build());
    }

    public <TEvent> CompletableFuture<EqlSearchResponse<TEvent>> search(EqlSearchRequest request, Class<TEvent> tEventClass) throws IOException {
        return this.transport.performRequestAsync(request, EqlSearchRequest.createSearchEndpoint(this.getDeserializer(tEventClass)));
    }

    public final <TEvent> CompletableFuture<EqlSearchResponse<TEvent>> search(Function<EqlSearchRequest.Builder, ObjectBuilder<EqlSearchRequest>> fn, Class<TEvent> tEventClass) throws IOException {
        return this.search(fn.apply(new EqlSearchRequest.Builder()).build(), tEventClass);
    }
}

