/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.termvectors;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Filter
implements JsonpSerializable {
    @Nullable
    private final Integer maxDocFreq;
    @Nullable
    private final Integer maxNumTerms;
    @Nullable
    private final Integer maxTermFreq;
    @Nullable
    private final Integer maxWordLength;
    @Nullable
    private final Integer minDocFreq;
    @Nullable
    private final Integer minTermFreq;
    @Nullable
    private final Integer minWordLength;
    public static final JsonpDeserializer<Filter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Filter::setupFilterDeserializer, Builder::build);

    public Filter(Builder builder) {
        this.maxDocFreq = builder.maxDocFreq;
        this.maxNumTerms = builder.maxNumTerms;
        this.maxTermFreq = builder.maxTermFreq;
        this.maxWordLength = builder.maxWordLength;
        this.minDocFreq = builder.minDocFreq;
        this.minTermFreq = builder.minTermFreq;
        this.minWordLength = builder.minWordLength;
    }

    public Filter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Integer maxDocFreq() {
        return this.maxDocFreq;
    }

    @Nullable
    public Integer maxNumTerms() {
        return this.maxNumTerms;
    }

    @Nullable
    public Integer maxTermFreq() {
        return this.maxTermFreq;
    }

    @Nullable
    public Integer maxWordLength() {
        return this.maxWordLength;
    }

    @Nullable
    public Integer minDocFreq() {
        return this.minDocFreq;
    }

    @Nullable
    public Integer minTermFreq() {
        return this.minTermFreq;
    }

    @Nullable
    public Integer minWordLength() {
        return this.minWordLength;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxDocFreq != null) {
            generator.writeKey("max_doc_freq");
            generator.write(this.maxDocFreq.intValue());
        }
        if (this.maxNumTerms != null) {
            generator.writeKey("max_num_terms");
            generator.write(this.maxNumTerms.intValue());
        }
        if (this.maxTermFreq != null) {
            generator.writeKey("max_term_freq");
            generator.write(this.maxTermFreq.intValue());
        }
        if (this.maxWordLength != null) {
            generator.writeKey("max_word_length");
            generator.write(this.maxWordLength.intValue());
        }
        if (this.minDocFreq != null) {
            generator.writeKey("min_doc_freq");
            generator.write(this.minDocFreq.intValue());
        }
        if (this.minTermFreq != null) {
            generator.writeKey("min_term_freq");
            generator.write(this.minTermFreq.intValue());
        }
        if (this.minWordLength != null) {
            generator.writeKey("min_word_length");
            generator.write(this.minWordLength.intValue());
        }
    }

    protected static void setupFilterDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::maxDocFreq, JsonpDeserializer.integerDeserializer(), "max_doc_freq", new String[0]);
        op.add(Builder::maxNumTerms, JsonpDeserializer.integerDeserializer(), "max_num_terms", new String[0]);
        op.add(Builder::maxTermFreq, JsonpDeserializer.integerDeserializer(), "max_term_freq", new String[0]);
        op.add(Builder::maxWordLength, JsonpDeserializer.integerDeserializer(), "max_word_length", new String[0]);
        op.add(Builder::minDocFreq, JsonpDeserializer.integerDeserializer(), "min_doc_freq", new String[0]);
        op.add(Builder::minTermFreq, JsonpDeserializer.integerDeserializer(), "min_term_freq", new String[0]);
        op.add(Builder::minWordLength, JsonpDeserializer.integerDeserializer(), "min_word_length", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Filter> {
        @Nullable
        private Integer maxDocFreq;
        @Nullable
        private Integer maxNumTerms;
        @Nullable
        private Integer maxTermFreq;
        @Nullable
        private Integer maxWordLength;
        @Nullable
        private Integer minDocFreq;
        @Nullable
        private Integer minTermFreq;
        @Nullable
        private Integer minWordLength;

        public Builder maxDocFreq(@Nullable Integer value) {
            this.maxDocFreq = value;
            return this;
        }

        public Builder maxNumTerms(@Nullable Integer value) {
            this.maxNumTerms = value;
            return this;
        }

        public Builder maxTermFreq(@Nullable Integer value) {
            this.maxTermFreq = value;
            return this;
        }

        public Builder maxWordLength(@Nullable Integer value) {
            this.maxWordLength = value;
            return this;
        }

        public Builder minDocFreq(@Nullable Integer value) {
            this.minDocFreq = value;
            return this;
        }

        public Builder minTermFreq(@Nullable Integer value) {
            this.minTermFreq = value;
            return this;
        }

        public Builder minWordLength(@Nullable Integer value) {
            this.minWordLength = value;
            return this;
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }
    }
}

