/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.termvectors;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class FieldStatistics
implements JsonpSerializable {
    private final int docCount;
    private final long sumDocFreq;
    private final long sumTtf;
    public static final JsonpDeserializer<FieldStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldStatistics::setupFieldStatisticsDeserializer, Builder::build);

    public FieldStatistics(Builder builder) {
        this.docCount = Objects.requireNonNull(builder.docCount, "doc_count");
        this.sumDocFreq = Objects.requireNonNull(builder.sumDocFreq, "sum_doc_freq");
        this.sumTtf = Objects.requireNonNull(builder.sumTtf, "sum_ttf");
    }

    public FieldStatistics(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int docCount() {
        return this.docCount;
    }

    public long sumDocFreq() {
        return this.sumDocFreq;
    }

    public long sumTtf() {
        return this.sumTtf;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("doc_count");
        generator.write(this.docCount);
        generator.writeKey("sum_doc_freq");
        generator.write(this.sumDocFreq);
        generator.writeKey("sum_ttf");
        generator.write(this.sumTtf);
    }

    protected static void setupFieldStatisticsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::docCount, JsonpDeserializer.integerDeserializer(), "doc_count", new String[0]);
        op.add(Builder::sumDocFreq, JsonpDeserializer.longDeserializer(), "sum_doc_freq", new String[0]);
        op.add(Builder::sumTtf, JsonpDeserializer.longDeserializer(), "sum_ttf", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FieldStatistics> {
        private Integer docCount;
        private Long sumDocFreq;
        private Long sumTtf;

        public Builder docCount(int value) {
            this.docCount = value;
            return this;
        }

        public Builder sumDocFreq(long value) {
            this.sumDocFreq = value;
            return this;
        }

        public Builder sumTtf(long value) {
            this.sumTtf = value;
            return this;
        }

        @Override
        public FieldStatistics build() {
            return new FieldStatistics(this);
        }
    }
}

