/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class Suggestion<T>
implements JsonpSerializable {
    private final int length;
    private final int offset;
    private final List<JsonValue> options;
    private final String text;
    @Nullable
    private final JsonpSerializer<T> tSerializer;

    public Suggestion(Builder<T> builder) {
        this.length = Objects.requireNonNull(((Builder)builder).length, "length");
        this.offset = Objects.requireNonNull(((Builder)builder).offset, "offset");
        this.options = ModelTypeHelper.unmodifiableNonNull(((Builder)builder).options, "options");
        this.text = Objects.requireNonNull(((Builder)builder).text, "text");
        this.tSerializer = ((Builder)builder).tSerializer;
    }

    public Suggestion(Function<Builder<T>, Builder<T>> fn) {
        this(fn.apply(new Builder()));
    }

    public int length() {
        return this.length;
    }

    public int offset() {
        return this.offset;
    }

    public List<JsonValue> options() {
        return this.options;
    }

    public String text() {
        return this.text;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("length");
        generator.write(this.length);
        generator.writeKey("offset");
        generator.write(this.offset);
        generator.writeKey("options");
        generator.writeStartArray();
        for (JsonValue item0 : this.options) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("text");
        generator.write(this.text);
    }

    public static <T> JsonpDeserializer<Suggestion<T>> createSuggestionDeserializer(JsonpDeserializer<T> tDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> Suggestion.setupSuggestionDeserializer(op, tDeserializer));
    }

    protected static <T> void setupSuggestionDeserializer(DelegatingDeserializer<Builder<T>> op, JsonpDeserializer<T> tDeserializer) {
        op.add(Builder::length, JsonpDeserializer.integerDeserializer(), "length", new String[0]);
        op.add(Builder::offset, JsonpDeserializer.integerDeserializer(), "offset", new String[0]);
        op.add(Builder::options, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "options", new String[0]);
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text", new String[0]);
    }

    public static class Builder<T>
    implements ObjectBuilder<Suggestion<T>> {
        private Integer length;
        private Integer offset;
        private List<JsonValue> options;
        private String text;
        @Nullable
        private JsonpSerializer<T> tSerializer;

        public Builder<T> length(int value) {
            this.length = value;
            return this;
        }

        public Builder<T> offset(int value) {
            this.offset = value;
            return this;
        }

        public Builder<T> options(List<JsonValue> value) {
            this.options = value;
            return this;
        }

        public Builder<T> options(JsonValue ... value) {
            this.options = Arrays.asList(value);
            return this;
        }

        public Builder<T> addOptions(JsonValue value) {
            if (this.options == null) {
                this.options = new ArrayList<JsonValue>();
            }
            this.options.add(value);
            return this;
        }

        public Builder<T> text(String value) {
            this.text = value;
            return this;
        }

        public Builder<T> tSerializer(@Nullable JsonpSerializer<T> value) {
            this.tSerializer = value;
            return this;
        }

        @Override
        public Suggestion<T> build() {
            return new Suggestion(this);
        }
    }
}

