/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class SuggesterBase
implements JsonpSerializable {
    private final String field;
    @Nullable
    private final String analyzer;
    @Nullable
    private final Integer size;

    public SuggesterBase(AbstractBuilder<?> builder) {
        this.field = Objects.requireNonNull(((AbstractBuilder)builder).field, "field");
        this.analyzer = ((AbstractBuilder)builder).analyzer;
        this.size = ((AbstractBuilder)builder).size;
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupSuggesterBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(AbstractBuilder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer", new String[0]);
        op.add(AbstractBuilder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        private String field;
        @Nullable
        private String analyzer;
        @Nullable
        private Integer size;

        protected AbstractBuilder() {
        }

        public BuilderT field(String value) {
            this.field = value;
            return this.self();
        }

        public BuilderT analyzer(@Nullable String value) {
            this.analyzer = value;
            return this.self();
        }

        public BuilderT size(@Nullable Integer value) {
            this.size = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

