/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.AggregationProfile;
import co.elastic.clients.elasticsearch.core.search.SearchProfile;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ShardProfile
implements JsonpSerializable {
    private final List<AggregationProfile> aggregations;
    private final String id;
    private final List<SearchProfile> searches;
    public static final JsonpDeserializer<ShardProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardProfile::setupShardProfileDeserializer, Builder::build);

    public ShardProfile(Builder builder) {
        this.aggregations = ModelTypeHelper.unmodifiableNonNull(builder.aggregations, "aggregations");
        this.id = Objects.requireNonNull(builder.id, "id");
        this.searches = ModelTypeHelper.unmodifiableNonNull(builder.searches, "searches");
    }

    public ShardProfile(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<AggregationProfile> aggregations() {
        return this.aggregations;
    }

    public String id() {
        return this.id;
    }

    public List<SearchProfile> searches() {
        return this.searches;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("aggregations");
        generator.writeStartArray();
        for (AggregationProfile aggregationProfile : this.aggregations) {
            aggregationProfile.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("searches");
        generator.writeStartArray();
        for (SearchProfile searchProfile : this.searches) {
            searchProfile.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupShardProfileDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.arrayDeserializer(AggregationProfile._DESERIALIZER), "aggregations", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::searches, JsonpDeserializer.arrayDeserializer(SearchProfile._DESERIALIZER), "searches", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardProfile> {
        private List<AggregationProfile> aggregations;
        private String id;
        private List<SearchProfile> searches;

        public Builder aggregations(List<AggregationProfile> value) {
            this.aggregations = value;
            return this;
        }

        public Builder aggregations(AggregationProfile ... value) {
            this.aggregations = Arrays.asList(value);
            return this;
        }

        public Builder addAggregations(AggregationProfile value) {
            if (this.aggregations == null) {
                this.aggregations = new ArrayList<AggregationProfile>();
            }
            this.aggregations.add(value);
            return this;
        }

        public Builder aggregations(Function<AggregationProfile.Builder, ObjectBuilder<AggregationProfile>> fn) {
            return this.aggregations(fn.apply(new AggregationProfile.Builder()).build());
        }

        public Builder addAggregations(Function<AggregationProfile.Builder, ObjectBuilder<AggregationProfile>> fn) {
            return this.addAggregations(fn.apply(new AggregationProfile.Builder()).build());
        }

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder searches(List<SearchProfile> value) {
            this.searches = value;
            return this;
        }

        public Builder searches(SearchProfile ... value) {
            this.searches = Arrays.asList(value);
            return this;
        }

        public Builder addSearches(SearchProfile value) {
            if (this.searches == null) {
                this.searches = new ArrayList<SearchProfile>();
            }
            this.searches.add(value);
            return this;
        }

        public Builder searches(Function<SearchProfile.Builder, ObjectBuilder<SearchProfile>> fn) {
            return this.searches(fn.apply(new SearchProfile.Builder()).build());
        }

        public Builder addSearches(Function<SearchProfile.Builder, ObjectBuilder<SearchProfile>> fn) {
            return this.addSearches(fn.apply(new SearchProfile.Builder()).build());
        }

        @Override
        public ShardProfile build() {
            return new ShardProfile(this);
        }
    }
}

