/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.ScoreMode;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RescoreQuery
implements JsonpSerializable {
    private final Query query;
    @Nullable
    private final Double queryWeight;
    @Nullable
    private final Double rescoreQueryWeight;
    @Nullable
    private final ScoreMode scoreMode;
    public static final JsonpDeserializer<RescoreQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RescoreQuery::setupRescoreQueryDeserializer, Builder::build);

    public RescoreQuery(Builder builder) {
        this.query = Objects.requireNonNull(builder.query, "rescore_query");
        this.queryWeight = builder.queryWeight;
        this.rescoreQueryWeight = builder.rescoreQueryWeight;
        this.scoreMode = builder.scoreMode;
    }

    public RescoreQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Query query() {
        return this.query;
    }

    @Nullable
    public Double queryWeight() {
        return this.queryWeight;
    }

    @Nullable
    public Double rescoreQueryWeight() {
        return this.rescoreQueryWeight;
    }

    @Nullable
    public ScoreMode scoreMode() {
        return this.scoreMode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("rescore_query");
        this.query.serialize(generator, mapper);
        if (this.queryWeight != null) {
            generator.writeKey("query_weight");
            generator.write(this.queryWeight.doubleValue());
        }
        if (this.rescoreQueryWeight != null) {
            generator.writeKey("rescore_query_weight");
            generator.write(this.rescoreQueryWeight.doubleValue());
        }
        if (this.scoreMode != null) {
            generator.writeKey("score_mode");
            this.scoreMode.serialize(generator, mapper);
        }
    }

    protected static void setupRescoreQueryDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::query, Query._DESERIALIZER, "rescore_query", new String[0]);
        op.add(Builder::queryWeight, JsonpDeserializer.doubleDeserializer(), "query_weight", new String[0]);
        op.add(Builder::rescoreQueryWeight, JsonpDeserializer.doubleDeserializer(), "rescore_query_weight", new String[0]);
        op.add(Builder::scoreMode, ScoreMode._DESERIALIZER, "score_mode", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RescoreQuery> {
        private Query query;
        @Nullable
        private Double queryWeight;
        @Nullable
        private Double rescoreQueryWeight;
        @Nullable
        private ScoreMode scoreMode;

        public Builder query(Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public Builder queryWeight(@Nullable Double value) {
            this.queryWeight = value;
            return this;
        }

        public Builder rescoreQueryWeight(@Nullable Double value) {
            this.rescoreQueryWeight = value;
            return this;
        }

        public Builder scoreMode(@Nullable ScoreMode value) {
            this.scoreMode = value;
            return this;
        }

        @Override
        public RescoreQuery build() {
            return new RescoreQuery(this);
        }
    }
}

