/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.QueryBreakdown;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class QueryProfile
implements JsonpSerializable {
    private final QueryBreakdown breakdown;
    private final String description;
    private final long timeInNanos;
    private final String type;
    @Nullable
    private final List<QueryProfile> children;
    public static final JsonpDeserializer<QueryProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryProfile::setupQueryProfileDeserializer, Builder::build);

    public QueryProfile(Builder builder) {
        this.breakdown = Objects.requireNonNull(builder.breakdown, "breakdown");
        this.description = Objects.requireNonNull(builder.description, "description");
        this.timeInNanos = Objects.requireNonNull(builder.timeInNanos, "time_in_nanos");
        this.type = Objects.requireNonNull(builder.type, "type");
        this.children = ModelTypeHelper.unmodifiable(builder.children);
    }

    public QueryProfile(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public QueryBreakdown breakdown() {
        return this.breakdown;
    }

    public String description() {
        return this.description;
    }

    public long timeInNanos() {
        return this.timeInNanos;
    }

    public String type() {
        return this.type;
    }

    @Nullable
    public List<QueryProfile> children() {
        return this.children;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("breakdown");
        this.breakdown.serialize(generator, mapper);
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("time_in_nanos");
        generator.write(this.timeInNanos);
        generator.writeKey("type");
        generator.write(this.type);
        if (this.children != null) {
            generator.writeKey("children");
            generator.writeStartArray();
            for (QueryProfile item0 : this.children) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupQueryProfileDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::breakdown, QueryBreakdown._DESERIALIZER, "breakdown", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::timeInNanos, JsonpDeserializer.longDeserializer(), "time_in_nanos", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
        op.add(Builder::children, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "children", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<QueryProfile> {
        private QueryBreakdown breakdown;
        private String description;
        private Long timeInNanos;
        private String type;
        @Nullable
        private List<QueryProfile> children;

        public Builder breakdown(QueryBreakdown value) {
            this.breakdown = value;
            return this;
        }

        public Builder breakdown(Function<QueryBreakdown.Builder, ObjectBuilder<QueryBreakdown>> fn) {
            return this.breakdown(fn.apply(new QueryBreakdown.Builder()).build());
        }

        public Builder description(String value) {
            this.description = value;
            return this;
        }

        public Builder timeInNanos(long value) {
            this.timeInNanos = value;
            return this;
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        public Builder children(@Nullable List<QueryProfile> value) {
            this.children = value;
            return this;
        }

        public Builder children(QueryProfile ... value) {
            this.children = Arrays.asList(value);
            return this;
        }

        public Builder addChildren(QueryProfile value) {
            if (this.children == null) {
                this.children = new ArrayList<QueryProfile>();
            }
            this.children.add(value);
            return this;
        }

        public Builder children(Function<Builder, ObjectBuilder<QueryProfile>> fn) {
            return this.children(fn.apply(new Builder()).build());
        }

        public Builder addChildren(Function<Builder, ObjectBuilder<QueryProfile>> fn) {
            return this.addChildren(fn.apply(new Builder()).build());
        }

        @Override
        public QueryProfile build() {
            return new QueryProfile(this);
        }
    }
}

