/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.ShardProfile;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class Profile
implements JsonpSerializable {
    private final List<ShardProfile> shards;
    public static final JsonpDeserializer<Profile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Profile::setupProfileDeserializer, Builder::build);

    public Profile(Builder builder) {
        this.shards = ModelTypeHelper.unmodifiableNonNull(builder.shards, "shards");
    }

    public Profile(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<ShardProfile> shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("shards");
        generator.writeStartArray();
        for (ShardProfile item0 : this.shards) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupProfileDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::shards, JsonpDeserializer.arrayDeserializer(ShardProfile._DESERIALIZER), "shards", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Profile> {
        private List<ShardProfile> shards;

        public Builder shards(List<ShardProfile> value) {
            this.shards = value;
            return this;
        }

        public Builder shards(ShardProfile ... value) {
            this.shards = Arrays.asList(value);
            return this;
        }

        public Builder addShards(ShardProfile value) {
            if (this.shards == null) {
                this.shards = new ArrayList<ShardProfile>();
            }
            this.shards.add(value);
            return this;
        }

        public Builder shards(Function<ShardProfile.Builder, ObjectBuilder<ShardProfile>> fn) {
            return this.shards(fn.apply(new ShardProfile.Builder()).build());
        }

        public Builder addShards(Function<ShardProfile.Builder, ObjectBuilder<ShardProfile>> fn) {
            return this.addShards(fn.apply(new ShardProfile.Builder()).build());
        }

        @Override
        public Profile build() {
            return new Profile(this);
        }
    }
}

