/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class InnerHitsMetadata
implements JsonpSerializable {
    private final JsonValue total;
    private final List<Hit<Map<String, JsonData>>> hits;
    @Nullable
    private final Double maxScore;
    public static final JsonpDeserializer<InnerHitsMetadata> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InnerHitsMetadata::setupInnerHitsMetadataDeserializer, Builder::build);

    public InnerHitsMetadata(Builder builder) {
        this.total = Objects.requireNonNull(builder.total, "total");
        this.hits = ModelTypeHelper.unmodifiableNonNull(builder.hits, "hits");
        this.maxScore = builder.maxScore;
    }

    public InnerHitsMetadata(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public JsonValue total() {
        return this.total;
    }

    public List<Hit<Map<String, JsonData>>> hits() {
        return this.hits;
    }

    @Nullable
    public Double maxScore() {
        return this.maxScore;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("hits");
        generator.writeStartArray();
        for (Hit<Map<String, JsonData>> item0 : this.hits) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.maxScore != null) {
            generator.writeKey("max_score");
            generator.write(this.maxScore.doubleValue());
        }
    }

    protected static void setupInnerHitsMetadataDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::total, JsonpDeserializer.jsonValueDeserializer(), "total", new String[0]);
        op.add(Builder::hits, JsonpDeserializer.arrayDeserializer(Hit.createHitDeserializer(JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER))), "hits", new String[0]);
        op.add(Builder::maxScore, JsonpDeserializer.doubleDeserializer(), "max_score", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<InnerHitsMetadata> {
        private JsonValue total;
        private List<Hit<Map<String, JsonData>>> hits;
        @Nullable
        private Double maxScore;

        public Builder total(JsonValue value) {
            this.total = value;
            return this;
        }

        public Builder hits(List<Hit<Map<String, JsonData>>> value) {
            this.hits = value;
            return this;
        }

        public Builder hits(Hit<Map<String, JsonData>> ... value) {
            this.hits = Arrays.asList(value);
            return this;
        }

        public Builder addHits(Hit<Map<String, JsonData>> value) {
            if (this.hits == null) {
                this.hits = new ArrayList<Hit<Map<String, JsonData>>>();
            }
            this.hits.add(value);
            return this;
        }

        public Builder hits(Function<Hit.Builder<Map<String, JsonData>>, ObjectBuilder<Hit<Map<String, JsonData>>>> fn) {
            return this.hits(fn.apply(new Hit.Builder()).build());
        }

        public Builder addHits(Function<Hit.Builder<Map<String, JsonData>>, ObjectBuilder<Hit<Map<String, JsonData>>>> fn) {
            return this.addHits(fn.apply(new Hit.Builder()).build());
        }

        public Builder maxScore(@Nullable Double value) {
            this.maxScore = value;
            return this;
        }

        @Override
        public InnerHitsMetadata build() {
            return new InnerHitsMetadata(this);
        }
    }
}

