/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.TotalHits;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class HitsMetadata<T>
implements JsonpSerializable {
    private final TotalHits total;
    private final List<Hit<T>> hits;
    @Nullable
    private final Double maxScore;
    @Nullable
    private final JsonpSerializer<T> tSerializer;

    public HitsMetadata(Builder<T> builder) {
        this.total = Objects.requireNonNull(((Builder)builder).total, "total");
        this.hits = ModelTypeHelper.unmodifiableNonNull(((Builder)builder).hits, "hits");
        this.maxScore = ((Builder)builder).maxScore;
        this.tSerializer = ((Builder)builder).tSerializer;
    }

    public HitsMetadata(Function<Builder<T>, Builder<T>> fn) {
        this(fn.apply(new Builder()));
    }

    public TotalHits total() {
        return this.total;
    }

    public List<Hit<T>> hits() {
        return this.hits;
    }

    @Nullable
    public Double maxScore() {
        return this.maxScore;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total");
        this.total.serialize(generator, mapper);
        generator.writeKey("hits");
        generator.writeStartArray();
        for (Hit<T> item0 : this.hits) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.maxScore != null) {
            generator.writeKey("max_score");
            generator.write(this.maxScore.doubleValue());
        }
    }

    public static <T> JsonpDeserializer<HitsMetadata<T>> createHitsMetadataDeserializer(JsonpDeserializer<T> tDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> HitsMetadata.setupHitsMetadataDeserializer(op, tDeserializer));
    }

    protected static <T> void setupHitsMetadataDeserializer(DelegatingDeserializer<Builder<T>> op, JsonpDeserializer<T> tDeserializer) {
        op.add(Builder::total, TotalHits._DESERIALIZER, "total", new String[0]);
        op.add(Builder::hits, JsonpDeserializer.arrayDeserializer(Hit.createHitDeserializer(tDeserializer)), "hits", new String[0]);
        op.add(Builder::maxScore, JsonpDeserializer.doubleDeserializer(), "max_score", new String[0]);
    }

    public static class Builder<T>
    implements ObjectBuilder<HitsMetadata<T>> {
        private TotalHits total;
        private List<Hit<T>> hits;
        @Nullable
        private Double maxScore;
        @Nullable
        private JsonpSerializer<T> tSerializer;

        public Builder<T> total(TotalHits value) {
            this.total = value;
            return this;
        }

        public Builder<T> total(Function<TotalHits.Builder, ObjectBuilder<TotalHits>> fn) {
            return this.total(fn.apply(new TotalHits.Builder()).build());
        }

        public Builder<T> hits(List<Hit<T>> value) {
            this.hits = value;
            return this;
        }

        public Builder<T> hits(Hit<T> ... value) {
            this.hits = Arrays.asList(value);
            return this;
        }

        public Builder<T> addHits(Hit<T> value) {
            if (this.hits == null) {
                this.hits = new ArrayList<Hit<T>>();
            }
            this.hits.add(value);
            return this;
        }

        public Builder<T> hits(Function<Hit.Builder<T>, ObjectBuilder<Hit<T>>> fn) {
            return this.hits(fn.apply(new Hit.Builder()).build());
        }

        public Builder<T> addHits(Function<Hit.Builder<T>, ObjectBuilder<Hit<T>>> fn) {
            return this.addHits(fn.apply(new Hit.Builder()).build());
        }

        public Builder<T> maxScore(@Nullable Double value) {
            this.maxScore = value;
            return this;
        }

        public Builder<T> tSerializer(@Nullable JsonpSerializer<T> value) {
            this.tSerializer = value;
            return this;
        }

        @Override
        public HitsMetadata<T> build() {
            return new HitsMetadata(this);
        }
    }
}

