/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.explain.Explanation;
import co.elastic.clients.elasticsearch.core.search.InnerHitsResult;
import co.elastic.clients.elasticsearch.core.search.NestedIdentity;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class Hit<TDocument>
implements JsonpSerializable {
    private final String index;
    private final String id;
    @Nullable
    private final Double score;
    @Nullable
    private final String type;
    @Nullable
    private final Explanation explanation;
    @Nullable
    private final Map<String, JsonData> fields;
    @Nullable
    private final Map<String, List<String>> highlight;
    @Nullable
    private final Map<String, InnerHitsResult> innerHits;
    @Nullable
    private final List<String> matchedQueries;
    @Nullable
    private final NestedIdentity nested;
    @Nullable
    private final List<String> ignored;
    @Nullable
    private final String shard;
    @Nullable
    private final String node;
    @Nullable
    private final String routing;
    @Nullable
    private final TDocument source;
    @Nullable
    private final Integer seqNo;
    @Nullable
    private final Long primaryTerm;
    @Nullable
    private final Long version;
    @Nullable
    private final List<String> sort;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    public Hit(Builder<TDocument> builder) {
        this.index = Objects.requireNonNull(((Builder)builder).index, "_index");
        this.id = Objects.requireNonNull(((Builder)builder).id, "_id");
        this.score = ((Builder)builder).score;
        this.type = ((Builder)builder).type;
        this.explanation = ((Builder)builder).explanation;
        this.fields = ModelTypeHelper.unmodifiable(((Builder)builder).fields);
        this.highlight = ModelTypeHelper.unmodifiable(((Builder)builder).highlight);
        this.innerHits = ModelTypeHelper.unmodifiable(((Builder)builder).innerHits);
        this.matchedQueries = ModelTypeHelper.unmodifiable(((Builder)builder).matchedQueries);
        this.nested = ((Builder)builder).nested;
        this.ignored = ModelTypeHelper.unmodifiable(((Builder)builder).ignored);
        this.shard = ((Builder)builder).shard;
        this.node = ((Builder)builder).node;
        this.routing = ((Builder)builder).routing;
        this.source = ((Builder)builder).source;
        this.seqNo = ((Builder)builder).seqNo;
        this.primaryTerm = ((Builder)builder).primaryTerm;
        this.version = ((Builder)builder).version;
        this.sort = ModelTypeHelper.unmodifiable(((Builder)builder).sort);
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public Hit(Function<Builder<TDocument>, Builder<TDocument>> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public Double score() {
        return this.score;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Nullable
    public Explanation explanation() {
        return this.explanation;
    }

    @Nullable
    public Map<String, JsonData> fields() {
        return this.fields;
    }

    @Nullable
    public Map<String, List<String>> highlight() {
        return this.highlight;
    }

    @Nullable
    public Map<String, InnerHitsResult> innerHits() {
        return this.innerHits;
    }

    @Nullable
    public List<String> matchedQueries() {
        return this.matchedQueries;
    }

    @Nullable
    public NestedIdentity nested() {
        return this.nested;
    }

    @Nullable
    public List<String> ignored() {
        return this.ignored;
    }

    @Nullable
    public String shard() {
        return this.shard;
    }

    @Nullable
    public String node() {
        return this.node;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public TDocument source() {
        return this.source;
    }

    @Nullable
    public Integer seqNo() {
        return this.seqNo;
    }

    @Nullable
    public Long primaryTerm() {
        return this.primaryTerm;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public List<String> sort() {
        return this.sort;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_index");
        generator.write(this.index);
        generator.writeKey("_id");
        generator.write(this.id);
        if (this.score != null) {
            generator.writeKey("_score");
            generator.write(this.score.doubleValue());
        }
        if (this.type != null) {
            generator.writeKey("_type");
            generator.write(this.type);
        }
        if (this.explanation != null) {
            generator.writeKey("_explanation");
            this.explanation.serialize(generator, mapper);
        }
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.highlight != null) {
            generator.writeKey("highlight");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.highlight.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.writeStartArray();
                for (String item1 : (List)entry.getValue()) {
                    generator.write(item1);
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.innerHits != null) {
            generator.writeKey("inner_hits");
            generator.writeStartObject();
            for (Map.Entry entry : this.innerHits.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((InnerHitsResult)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.matchedQueries != null) {
            generator.writeKey("matched_queries");
            generator.writeStartArray();
            for (String string : this.matchedQueries) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.nested != null) {
            generator.writeKey("_nested");
            this.nested.serialize(generator, mapper);
        }
        if (this.ignored != null) {
            generator.writeKey("_ignored");
            generator.writeStartArray();
            for (String string : this.ignored) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.shard != null) {
            generator.writeKey("_shard");
            generator.write(this.shard);
        }
        if (this.node != null) {
            generator.writeKey("_node");
            generator.write(this.node);
        }
        if (this.routing != null) {
            generator.writeKey("_routing");
            generator.write(this.routing);
        }
        if (this.source != null) {
            generator.writeKey("_source");
            JsonpUtils.serialize(this.source, generator, this.tDocumentSerializer, mapper);
        }
        if (this.seqNo != null) {
            generator.writeKey("_seq_no");
            generator.write(this.seqNo.intValue());
        }
        if (this.primaryTerm != null) {
            generator.writeKey("_primary_term");
            generator.write(this.primaryTerm.longValue());
        }
        if (this.version != null) {
            generator.writeKey("_version");
            generator.write(this.version.longValue());
        }
        if (this.sort != null) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (String string : this.sort) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    public static <TDocument> JsonpDeserializer<Hit<TDocument>> createHitDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> Hit.setupHitDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupHitDeserializer(DelegatingDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id", new String[0]);
        op.add(Builder::score, JsonpDeserializer.doubleDeserializer(), "_score", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "_type", new String[0]);
        op.add(Builder::explanation, Explanation._DESERIALIZER, "_explanation", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "fields", new String[0]);
        op.add(Builder::highlight, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "highlight", new String[0]);
        op.add(Builder::innerHits, JsonpDeserializer.stringMapDeserializer(InnerHitsResult._DESERIALIZER), "inner_hits", new String[0]);
        op.add(Builder::matchedQueries, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "matched_queries", new String[0]);
        op.add(Builder::nested, NestedIdentity._DESERIALIZER, "_nested", new String[0]);
        op.add(Builder::ignored, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "_ignored", new String[0]);
        op.add(Builder::shard, JsonpDeserializer.stringDeserializer(), "_shard", new String[0]);
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "_node", new String[0]);
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "_routing", new String[0]);
        op.add(Builder::source, tDocumentDeserializer, "_source", new String[0]);
        op.add(Builder::seqNo, JsonpDeserializer.integerDeserializer(), "_seq_no", new String[0]);
        op.add(Builder::primaryTerm, JsonpDeserializer.longDeserializer(), "_primary_term", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "_version", new String[0]);
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "sort", new String[0]);
    }

    public static class Builder<TDocument>
    implements ObjectBuilder<Hit<TDocument>> {
        private String index;
        private String id;
        @Nullable
        private Double score;
        @Nullable
        private String type;
        @Nullable
        private Explanation explanation;
        @Nullable
        private Map<String, JsonData> fields;
        @Nullable
        private Map<String, List<String>> highlight;
        @Nullable
        private Map<String, InnerHitsResult> innerHits;
        @Nullable
        private List<String> matchedQueries;
        @Nullable
        private NestedIdentity nested;
        @Nullable
        private List<String> ignored;
        @Nullable
        private String shard;
        @Nullable
        private String node;
        @Nullable
        private String routing;
        @Nullable
        private TDocument source;
        @Nullable
        private Integer seqNo;
        @Nullable
        private Long primaryTerm;
        @Nullable
        private Long version;
        @Nullable
        private List<String> sort;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public Builder<TDocument> index(String value) {
            this.index = value;
            return this;
        }

        public Builder<TDocument> id(String value) {
            this.id = value;
            return this;
        }

        public Builder<TDocument> score(@Nullable Double value) {
            this.score = value;
            return this;
        }

        public Builder<TDocument> type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public Builder<TDocument> explanation(@Nullable Explanation value) {
            this.explanation = value;
            return this;
        }

        public Builder<TDocument> explanation(Function<Explanation.Builder, ObjectBuilder<Explanation>> fn) {
            return this.explanation(fn.apply(new Explanation.Builder()).build());
        }

        public Builder<TDocument> fields(@Nullable Map<String, JsonData> value) {
            this.fields = value;
            return this;
        }

        public Builder<TDocument> putFields(String key, JsonData value) {
            if (this.fields == null) {
                this.fields = new HashMap<String, JsonData>();
            }
            this.fields.put(key, value);
            return this;
        }

        public Builder<TDocument> highlight(@Nullable Map<String, List<String>> value) {
            this.highlight = value;
            return this;
        }

        public Builder<TDocument> putHighlight(String key, List<String> value) {
            if (this.highlight == null) {
                this.highlight = new HashMap<String, List<String>>();
            }
            this.highlight.put(key, value);
            return this;
        }

        public Builder<TDocument> innerHits(@Nullable Map<String, InnerHitsResult> value) {
            this.innerHits = value;
            return this;
        }

        public Builder<TDocument> putInnerHits(String key, InnerHitsResult value) {
            if (this.innerHits == null) {
                this.innerHits = new HashMap<String, InnerHitsResult>();
            }
            this.innerHits.put(key, value);
            return this;
        }

        public Builder<TDocument> innerHits(String key, Function<InnerHitsResult.Builder, ObjectBuilder<InnerHitsResult>> fn) {
            return this.innerHits(Collections.singletonMap(key, fn.apply(new InnerHitsResult.Builder()).build()));
        }

        public Builder<TDocument> putInnerHits(String key, Function<InnerHitsResult.Builder, ObjectBuilder<InnerHitsResult>> fn) {
            return this.putInnerHits(key, fn.apply(new InnerHitsResult.Builder()).build());
        }

        public Builder<TDocument> matchedQueries(@Nullable List<String> value) {
            this.matchedQueries = value;
            return this;
        }

        public Builder<TDocument> matchedQueries(String ... value) {
            this.matchedQueries = Arrays.asList(value);
            return this;
        }

        public Builder<TDocument> addMatchedQueries(String value) {
            if (this.matchedQueries == null) {
                this.matchedQueries = new ArrayList<String>();
            }
            this.matchedQueries.add(value);
            return this;
        }

        public Builder<TDocument> nested(@Nullable NestedIdentity value) {
            this.nested = value;
            return this;
        }

        public Builder<TDocument> nested(Function<NestedIdentity.Builder, ObjectBuilder<NestedIdentity>> fn) {
            return this.nested(fn.apply(new NestedIdentity.Builder()).build());
        }

        public Builder<TDocument> ignored(@Nullable List<String> value) {
            this.ignored = value;
            return this;
        }

        public Builder<TDocument> ignored(String ... value) {
            this.ignored = Arrays.asList(value);
            return this;
        }

        public Builder<TDocument> addIgnored(String value) {
            if (this.ignored == null) {
                this.ignored = new ArrayList<String>();
            }
            this.ignored.add(value);
            return this;
        }

        public Builder<TDocument> shard(@Nullable String value) {
            this.shard = value;
            return this;
        }

        public Builder<TDocument> node(@Nullable String value) {
            this.node = value;
            return this;
        }

        public Builder<TDocument> routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder<TDocument> source(@Nullable TDocument value) {
            this.source = value;
            return this;
        }

        public Builder<TDocument> seqNo(@Nullable Integer value) {
            this.seqNo = value;
            return this;
        }

        public Builder<TDocument> primaryTerm(@Nullable Long value) {
            this.primaryTerm = value;
            return this;
        }

        public Builder<TDocument> version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public Builder<TDocument> sort(@Nullable List<String> value) {
            this.sort = value;
            return this;
        }

        public Builder<TDocument> sort(String ... value) {
            this.sort = Arrays.asList(value);
            return this;
        }

        public Builder<TDocument> addSort(String value) {
            if (this.sort == null) {
                this.sort = new ArrayList<String>();
            }
            this.sort.add(value);
            return this;
        }

        public Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public Hit<TDocument> build() {
            return new Hit(this);
        }
    }
}

